/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.net.impl;

import znaishaded.io.netty.buffer.ByteBuf;
import znaishaded.io.netty.buffer.ByteBufAllocator;
import znaishaded.io.netty.buffer.CompositeByteBuf;
import znaishaded.io.netty.buffer.Unpooled;
import znaishaded.io.netty.channel.Channel;
import znaishaded.io.netty.channel.ChannelDuplexHandler;
import znaishaded.io.netty.channel.ChannelHandlerContext;
import znaishaded.io.netty.handler.timeout.IdleState;
import znaishaded.io.netty.handler.timeout.IdleStateEvent;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.impl.ContextImpl;
import znaishaded.io.vertx.core.impl.ContextTask;
import znaishaded.io.vertx.core.net.impl.ConnectionBase;

public abstract class VertxHandler<C extends ConnectionBase>
extends ChannelDuplexHandler {
    private C conn;
    private ContextTask endReadAndFlush;
    private Handler<C> addHandler;
    private Handler<C> removeHandler;

    protected void setConnection(C connection) {
        this.conn = connection;
        this.endReadAndFlush = () -> this.conn.endReadAndFlush();
        if (this.addHandler != null) {
            this.addHandler.handle(connection);
        }
    }

    public VertxHandler<C> addHandler(Handler<C> handler) {
        this.addHandler = handler;
        return this;
    }

    public VertxHandler<C> removeHandler(Handler<C> handler) {
        this.removeHandler = handler;
        return this;
    }

    public C getConnection() {
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf safeBuffer(ByteBuf buf, ByteBufAllocator allocator) {
        if (buf == Unpooled.EMPTY_BUFFER) {
            return buf;
        }
        if (buf.isDirect() || buf instanceof CompositeByteBuf) {
            try {
                if (buf.isReadable()) {
                    ByteBuf buffer = allocator.heapBuffer(buf.readableBytes());
                    buffer.writeBytes(buf);
                    ByteBuf byteBuf = buffer;
                    return byteBuf;
                }
                ByteBuf byteBuf = Unpooled.EMPTY_BUFFER;
                return byteBuf;
            }
            finally {
                buf.release();
            }
        }
        return buf;
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        C conn = this.getConnection();
        ContextImpl context = ((ConnectionBase)conn).getContext();
        context.executeFromIO(() -> conn.handleInterestedOpsChanged());
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext chctx, Throwable t) throws Exception {
        Channel ch = chctx.channel();
        Object connection = this.getConnection();
        if (connection != null) {
            ContextImpl context = ((ConnectionBase)this.conn).getContext();
            context.executeFromIO(() -> {
                try {
                    if (ch.isOpen()) {
                        ch.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                connection.handleException(t);
            });
        } else {
            ch.close();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext chctx) throws Exception {
        if (this.removeHandler != null) {
            this.removeHandler.handle(this.conn);
        }
        ContextImpl context = ((ConnectionBase)this.conn).getContext();
        context.executeFromIO(() -> this.conn.handleClosed());
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ContextImpl context = ((ConnectionBase)this.conn).getContext();
        context.executeFromIO(this.endReadAndFlush);
    }

    @Override
    public void channelRead(ChannelHandlerContext chctx, Object msg) throws Exception {
        Object message = this.decode(msg, chctx.alloc());
        ContextImpl context = ((ConnectionBase)this.conn).getContext();
        context.executeFromIO(() -> {
            ((ConnectionBase)this.conn).startRead();
            this.handleMessage(this.conn, context, chctx, message);
        });
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.ALL_IDLE) {
            ctx.close();
        }
        ctx.fireUserEventTriggered(evt);
    }

    protected abstract void handleMessage(C var1, ContextImpl var2, ChannelHandlerContext var3, Object var4) throws Exception;

    protected abstract Object decode(Object var1, ByteBufAllocator var2) throws Exception;
}

