/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3;

import java.util.Collection;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.Instruction;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionList;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.WeldingPoint;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.Rainbow;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NoteType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Branch {
    private final InstructionList list;
    private final Display labelTest;
    private final Display labelPositive;
    private final Display inlabel;
    private final HtmlColor color;
    private LinkRendering inlinkRendering = LinkRendering.none();
    private Ftile ftile;

    public Branch(Swimlane swimlane, Display display, Display display2, HtmlColor htmlColor, Display display3) {
        if (display == null) {
            throw new IllegalArgumentException();
        }
        if (display2 == null) {
            throw new IllegalArgumentException();
        }
        if (display3 == null) {
            throw new IllegalArgumentException();
        }
        this.inlabel = display3;
        this.list = new InstructionList(swimlane);
        this.labelTest = display2;
        this.labelPositive = display;
        this.color = htmlColor;
    }

    public Collection<WeldingPoint> getWeldingPoints() {
        return this.ftile.getWeldingPoints();
    }

    public void add(Instruction instruction) {
        this.list.add(instruction);
    }

    public boolean kill() {
        return this.list.kill();
    }

    public boolean addNote(Display display, NotePosition notePosition, NoteType noteType, Colors colors, Swimlane swimlane) {
        return this.list.addNote(display, notePosition, noteType, colors, swimlane);
    }

    public final void setInlinkRendering(LinkRendering linkRendering) {
        if (linkRendering == null) {
            throw new IllegalArgumentException();
        }
        this.inlinkRendering = linkRendering;
    }

    public void updateFtile(FtileFactory ftileFactory) {
        this.ftile = ftileFactory.decorateOut(this.list.createFtile(ftileFactory), this.inlinkRendering);
    }

    public Collection<? extends Swimlane> getSwimlanes() {
        return this.list.getSwimlanes();
    }

    public final Display getLabelPositive() {
        LinkRendering linkRendering = this.ftile.getInLinkRendering();
        if (linkRendering != null && !Display.isNull(linkRendering.getDisplay())) {
            return linkRendering.getDisplay();
        }
        return this.labelPositive;
    }

    public final Display getLabelTest() {
        return this.labelTest;
    }

    public final Rainbow getInlinkRenderingColorAndStyle() {
        return this.inlinkRendering == null ? null : this.inlinkRendering.getRainbow();
    }

    public Display getInlabel() {
        return this.inlabel;
    }

    public final Ftile getFtile() {
        return this.ftile;
    }

    public ISkinParam skinParam() {
        return this.ftile.skinParam();
    }

    public final HtmlColor getColor() {
        return this.color;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public Instruction getLast() {
        return this.list.getLast();
    }

    public boolean isOnlySingleStop() {
        return this.list.isOnlySingleStop();
    }
}

