/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileKilled;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.MergeStrategy;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.ParallelFtilesBuilder;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.UGraphicInterceptorOneSwimlane;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorAndStyle;
import znaishaded.net.sourceforge.plantuml.graphic.Rainbow;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelBuilderSplit
extends ParallelFtilesBuilder {
    public ParallelBuilderSplit(ISkinParam iSkinParam, StringBounder stringBounder, List<Ftile> list, Ftile ftile, Swimlane swimlane) {
        super(iSkinParam, stringBounder, list, ftile, swimlane);
    }

    @Override
    protected Ftile doStep1() {
        Ftile ftile = this.getMiddle();
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        double d = 0.0;
        for (Ftile ftile2 : this.getList()) {
            FtileGeometry ftileGeometry = ftile2.calculateDimension(this.getStringBounder());
            arrayList.add(new ConnectionIn(ftile2, d, ftile2.getInLinkRendering().getRainbow(HtmlColorAndStyle.build(this.skinParam())), this.getTextBlock(ftile2.getInLinkRendering())));
            d += ((Dimension2D)ftileGeometry).getWidth();
        }
        double d2 = ftile.calculateDimension(this.getStringBounder()).getWidth();
        arrayList.add(new ConnectionHline2(ftile, HtmlColorAndStyle.build(this.skinParam()), 0.0, this.getList(), d2));
        ftile = FtileUtils.addConnection(ftile, arrayList);
        return ftile;
    }

    @Override
    protected Ftile doStep2(Ftile ftile) {
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        double d = 0.0;
        boolean bl = false;
        for (Ftile ftile2 : this.getList()) {
            FtileGeometry ftileGeometry = ftile2.calculateDimension(this.getStringBounder());
            boolean bl2 = ftile2.calculateDimension(this.getStringBounder()).hasPointOut();
            if (bl2) {
                arrayList.add(new ConnectionOut(ftile2, d, ftile2.getOutLinkRendering().getRainbow(HtmlColorAndStyle.build(this.skinParam())), this.getHeightOfMiddle(), this.getTextBlock(ftile2.getOutLinkRendering())));
                bl = true;
            }
            d += ((Dimension2D)ftileGeometry).getWidth();
        }
        if (bl) {
            double d2 = ftile.calculateDimension(this.getStringBounder()).getWidth();
            arrayList.add(new ConnectionHline2(ftile, HtmlColorAndStyle.build(this.skinParam()), this.getHeightOfMiddle(), this.getList(), d2));
            ftile = FtileUtils.addConnection(ftile, arrayList);
        } else {
            ftile = new FtileKilled(ftile);
        }
        return ftile;
    }

    static class ConnectionOut
    extends AbstractConnection {
        private final double x;
        private final Rainbow arrowColor;
        private final double height;
        private final TextBlock text;

        public ConnectionOut(Ftile ftile, double d, Rainbow rainbow, double d2, TextBlock textBlock) {
            super(ftile, null);
            this.x = d;
            this.arrowColor = rainbow;
            this.height = d2;
            this.text = textBlock;
        }

        public void drawU(UGraphic uGraphic) {
            uGraphic = uGraphic.apply(new UTranslate(this.x, 0.0));
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(uGraphic.getStringBounder());
            if (!ftileGeometry.hasPointOut()) {
                assert (false);
                return;
            }
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            snake.setLabel(this.text);
            snake.goUnmergeable(MergeStrategy.NONE);
            snake.addPoint(ftileGeometry.getLeft(), ftileGeometry.getOutY());
            snake.addPoint(ftileGeometry.getLeft(), this.height);
            uGraphic.draw(snake);
        }
    }

    static class ConnectionIn
    extends AbstractConnection {
        private final double x;
        private final Rainbow arrowColor;
        private final TextBlock text;

        public ConnectionIn(Ftile ftile, double d, Rainbow rainbow, TextBlock textBlock) {
            super(null, ftile);
            this.x = d;
            this.arrowColor = rainbow;
            this.text = textBlock;
        }

        public void drawU(UGraphic uGraphic) {
            uGraphic = uGraphic.apply(new UTranslate(this.x, 0.0));
            FtileGeometry ftileGeometry = this.getFtile2().calculateDimension(uGraphic.getStringBounder());
            double d = ftileGeometry.getLeft();
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            snake.setLabel(this.text);
            snake.addPoint(d, 0.0);
            snake.addPoint(d, ftileGeometry.getInY());
            uGraphic.draw(snake);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConnectionHline3
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Ftile inner;
        private final double y;
        private final Rainbow arrowColor;
        private final List<Ftile> list;
        private final double totalWidth;

        public ConnectionHline3(Ftile ftile, Rainbow rainbow, double d, List<Ftile> list, double d2) {
            super(null, null);
            this.inner = ftile;
            this.y = d;
            this.arrowColor = rainbow;
            this.list = list;
            this.totalWidth = d2;
        }

        @Override
        public void drawU(UGraphic uGraphic) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void drawTranslate(UGraphic uGraphic, UTranslate uTranslate, UTranslate uTranslate2) {
            double d;
            StringBounder stringBounder = uGraphic.getStringBounder();
            UTranslate uTranslate3 = this.inner.getSwimlaneIn().getTranslate();
            double d2 = d = this.inner.calculateDimension(stringBounder).getLeft() + uTranslate3.getDx();
            for (Ftile uShape2 : this.list) {
                FtileGeometry ftileGeometry = uShape2.calculateDimension(stringBounder);
                UTranslate uTranslate4 = this.inner.getTranslateFor(uShape2, stringBounder);
                for (Swimlane swimlane : uShape2.getSwimlanes()) {
                    double d3 = ftileGeometry.translate(swimlane.getTranslate().compose(uTranslate4)).getLeft();
                    d = Math.min(d, d3);
                    d2 = Math.max(d2, d3);
                }
            }
            FtileGeometry ftileGeometry = this.inner.calculateDimension(stringBounder);
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor);
            snake.goUnmergeable(MergeStrategy.LIMITED);
            snake.addPoint(d, this.y);
            snake.addPoint(d2, this.y);
            uGraphic.draw(snake);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConnectionHline2
    extends AbstractConnection {
        private final Ftile inner;
        private final double y;
        private final Rainbow arrowColor;
        private final List<Ftile> list;
        private final double totalWidth;

        public ConnectionHline2(Ftile ftile, Rainbow rainbow, double d, List<Ftile> list, double d2) {
            super(null, null);
            this.inner = ftile;
            this.y = d;
            this.arrowColor = rainbow;
            this.list = list;
            this.totalWidth = d2;
        }

        @Override
        public void drawU(UGraphic uGraphic) {
            Object object;
            double d = Double.MAX_VALUE;
            double d2 = 0.0;
            if (this.y == 0.0 && uGraphic instanceof UGraphicInterceptorOneSwimlane) {
                object = ((UGraphicInterceptorOneSwimlane)uGraphic).getSwimlane();
                boolean bl = false;
                for (Ftile ftile : this.list) {
                    if (ftile.getSwimlaneIn() != object) continue;
                    bl = true;
                }
                if (!bl) {
                    return;
                }
            }
            object = uGraphic.getStringBounder();
            for (Ftile ftile : this.list) {
                UTranslate uTranslate;
                if (this.y > 0.0 && !ftile.calculateDimension((StringBounder)object).hasPointOut() || (uTranslate = this.inner.getTranslateFor(ftile, (StringBounder)object)) == null) continue;
                double d3 = ftile.calculateDimension((StringBounder)object).translate(uTranslate).getLeft();
                d = Math.min(d, d3);
                d2 = Math.max(d2, d3);
            }
            if (d > this.totalWidth / 2.0) {
                d = this.totalWidth / 2.0;
            }
            if (d2 < this.totalWidth / 2.0) {
                d2 = this.totalWidth / 2.0;
            }
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor);
            snake.goUnmergeable(MergeStrategy.NONE);
            snake.addPoint(d, this.y);
            snake.addPoint(d2, this.y);
            uGraphic.draw(snake);
        }
    }
}

