/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.awt.geom.Dimension2D;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Diamond;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileDiamond
extends AbstractFtile {
    private final HtmlColor backColor;
    private final HtmlColor borderColor;
    private final Swimlane swimlane;
    private final TextBlock north;
    private final TextBlock south;
    private final TextBlock west1;
    private final TextBlock east1;

    public FtileDiamond(ISkinParam iSkinParam, HtmlColor htmlColor, HtmlColor htmlColor2, Swimlane swimlane) {
        this(iSkinParam, htmlColor, htmlColor2, swimlane, TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0));
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.emptyList();
    }

    public FtileDiamond withNorth(TextBlock textBlock) {
        return new FtileDiamond(this.skinParam(), this.backColor, this.borderColor, this.swimlane, textBlock, this.south, this.east1, this.west1);
    }

    public FtileDiamond withWest(TextBlock textBlock) {
        if (textBlock == null) {
            return this;
        }
        return new FtileDiamond(this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.north, this.south, this.east1, textBlock);
    }

    public FtileDiamond withEast(TextBlock textBlock) {
        if (textBlock == null) {
            return this;
        }
        return new FtileDiamond(this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.north, this.south, textBlock, this.west1);
    }

    public FtileDiamond withSouth(TextBlock textBlock) {
        return new FtileDiamond(this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.north, textBlock, this.east1, this.west1);
    }

    private FtileDiamond(ISkinParam iSkinParam, HtmlColor htmlColor, HtmlColor htmlColor2, Swimlane swimlane, TextBlock textBlock, TextBlock textBlock2, TextBlock textBlock3, TextBlock textBlock4) {
        super(iSkinParam);
        this.backColor = htmlColor;
        this.swimlane = swimlane;
        this.borderColor = htmlColor2;
        this.north = textBlock;
        this.west1 = textBlock4;
        this.east1 = textBlock3;
        this.south = textBlock2;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        double d = this.north.calculateDimension(uGraphic.getStringBounder()).getHeight();
        uGraphic = uGraphic.apply(new UTranslate(0.0, d));
        uGraphic.apply(new UChangeColor(this.borderColor)).apply(this.getThickness()).apply(new UChangeBackColor(this.backColor)).draw(Diamond.asPolygon(this.skinParam().shadowing()));
        this.north.drawU(uGraphic.apply(new UTranslate(18.0, -d)));
        this.south.drawU(uGraphic.apply(new UTranslate(18.0, 24.0)));
        Dimension2D dimension2D = this.west1.calculateDimension(uGraphic.getStringBounder());
        this.west1.drawU(uGraphic.apply(new UTranslate(-dimension2D.getWidth(), -dimension2D.getHeight() + 12.0)));
        Dimension2D dimension2D2 = this.east1.calculateDimension(uGraphic.getStringBounder());
        this.east1.drawU(uGraphic.apply(new UTranslate(24.0, -dimension2D2.getHeight() + 12.0)));
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        double d = this.north.calculateDimension(stringBounder).getHeight();
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(24.0, 24.0 + d);
        return new FtileGeometry(dimension2DDouble, ((Dimension2D)dimension2DDouble).getWidth() / 2.0, d, ((Dimension2D)dimension2DDouble).getHeight());
    }

    public Ftile withWestAndEast(TextBlock textBlock, TextBlock textBlock2) {
        return this.withWest(textBlock).withEast(textBlock2);
    }

    public double getEastLabelWidth(StringBounder stringBounder) {
        Dimension2D dimension2D = this.east1.calculateDimension(stringBounder);
        return dimension2D.getWidth();
    }

    public double getSouthLabelHeight(StringBounder stringBounder) {
        Dimension2D dimension2D = this.south.calculateDimension(stringBounder);
        return dimension2D.getHeight();
    }
}

