/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.creole.Atom;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class Bullet
implements Atom {
    private final FontConfiguration fontConfiguration;
    private final int order;

    public Bullet(FontConfiguration fontConfiguration, int n) {
        this.fontConfiguration = fontConfiguration;
        this.order = n;
    }

    private double getWidth(StringBounder stringBounder) {
        Dimension2D dimension2D = stringBounder.calculateDimension(this.fontConfiguration.getFont(), "W");
        return dimension2D.getWidth() * (double)(this.order + 1);
    }

    public void drawU(UGraphic uGraphic) {
        if (this.order == 0) {
            this.drawU0(uGraphic);
        } else {
            this.drawU1(uGraphic);
        }
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        if (this.order == 0) {
            return this.calculateDimension0(stringBounder);
        }
        return this.calculateDimension1(stringBounder);
    }

    private void drawU0(UGraphic uGraphic) {
        HtmlColor htmlColor = this.fontConfiguration.getColor();
        uGraphic = uGraphic.apply(new UChangeColor(htmlColor)).apply(new UChangeBackColor(htmlColor)).apply(new UStroke(0.0));
        uGraphic = uGraphic.apply(new UTranslate(3.0, 0.0));
        uGraphic.draw(new UEllipse(5.0, 5.0));
    }

    public double getStartingAltitude(StringBounder stringBounder) {
        return -5.0;
    }

    private Dimension2D calculateDimension0(StringBounder stringBounder) {
        return new Dimension2DDouble(this.getWidth(stringBounder), 5.0);
    }

    private void drawU1(UGraphic uGraphic) {
        HtmlColor htmlColor = this.fontConfiguration.getColor();
        uGraphic = uGraphic.apply(new UChangeColor(htmlColor)).apply(new UChangeBackColor(htmlColor)).apply(new UStroke(0.0));
        double d = this.getWidth(uGraphic.getStringBounder());
        uGraphic = uGraphic.apply(new UTranslate(d - 5.0, 0.0));
        uGraphic.draw(new URectangle(3.5, 3.5));
    }

    private Dimension2D calculateDimension1(StringBounder stringBounder) {
        return new Dimension2DDouble(this.getWidth(stringBounder), 3.0);
    }
}

