/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.geom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.geom.AbstractFigure;
import znaishaded.net.sourceforge.plantuml.geom.LineSegmentInt;
import znaishaded.net.sourceforge.plantuml.geom.Point2DInt;

public class ClosedArea
extends AbstractFigure {
    private final List<Point2DInt> points = new ArrayList<Point2DInt>();
    private final List<LineSegmentInt> segmentsList = new ArrayList<LineSegmentInt>();
    private int minY = Integer.MAX_VALUE;
    private int minX = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int maxY = Integer.MIN_VALUE;

    public ClosedArea() {
        assert (this.isConsistent());
    }

    public String toString() {
        return this.points.toString();
    }

    public boolean contains(Point2DInt point2DInt) {
        return this.contains(point2DInt.getXint(), point2DInt.getYint());
    }

    /*
     * Unable to fully structure code
     */
    private boolean contains(int var1_1, int var2_2) {
        if (this.points.size() <= 2) {
            return false;
        }
        if (var1_1 > this.maxX) {
            return false;
        }
        if (var1_1 < this.minX) {
            return false;
        }
        if (var2_2 > this.maxY) {
            return false;
        }
        if (var2_2 < this.minY) {
            return false;
        }
        if (this.isOnFrontier(new Point2DInt(var1_1, var2_2))) {
            return true;
        }
        var3_3 = 0;
        var4_4 = this.getLastPoint().getXint();
        var5_5 = this.getLastPoint().getYint();
        for (var8_6 = 0; var8_6 < this.points.size(); ++var8_6) {
            block13: {
                block16: {
                    block17: {
                        block15: {
                            block14: {
                                var6_7 = this.points.get(var8_6).getXint();
                                var7_8 = this.points.get(var8_6).getYint();
                                if (var7_8 == var5_5) break block13;
                                if (var6_7 >= var4_4) break block14;
                                if (var1_1 >= var4_4) break block13;
                                var9_9 = var6_7;
                                break block15;
                            }
                            if (var1_1 >= var6_7) break block13;
                            var9_9 = var4_4;
                        }
                        if (var7_8 >= var5_5) break block16;
                        if (var2_2 < var7_8 || var2_2 >= var5_5) break block13;
                        if (var1_1 >= var9_9) break block17;
                        ++var3_3;
                        break block13;
                    }
                    var10_10 = var1_1 - var6_7;
                    var12_11 = var2_2 - var7_8;
                    ** GOTO lbl44
                }
                if (var2_2 < var5_5 || var2_2 >= var7_8) break block13;
                if (var1_1 < var9_9) {
                    ++var3_3;
                } else {
                    var10_10 = var1_1 - var4_4;
                    var12_11 = var2_2 - var5_5;
lbl44:
                    // 2 sources

                    if (var10_10 < var12_11 / (double)(var5_5 - var7_8) * (double)(var4_4 - var6_7)) {
                        ++var3_3;
                    }
                }
            }
            var4_4 = var6_7;
            var5_5 = var7_8;
        }
        return (var3_3 & true) != false;
    }

    private boolean isConsistent() {
        assert (this.getSegments().size() == this.segmentsList.size());
        assert (this.getSegments().equals(new HashSet<LineSegmentInt>(this.segmentsList)));
        if (this.getSegments().size() > 0) assert (this.getSegments().size() + 1 == this.points.size()) : "points=" + this.points + " getSegment()=" + this.getSegments();
        for (int i = 0; i < this.segmentsList.size(); ++i) {
            LineSegmentInt lineSegmentInt = this.segmentsList.get(i);
            if (lineSegmentInt.sameExtremities(new LineSegmentInt(this.points.get(i), this.points.get(i + 1)))) continue;
            return false;
        }
        return true;
    }

    public boolean isOnFrontier(Point2DInt point2DInt) {
        for (LineSegmentInt lineSegmentInt : this.segmentsList) {
            if (!lineSegmentInt.containsPoint(point2DInt)) continue;
            return true;
        }
        return false;
    }

    public boolean isClosed() {
        if (this.getSegments().size() < 3) {
            return false;
        }
        return this.getFirstSegment().atLeastOneCommonExtremities(this.getLastSegment());
    }

    ClosedArea append(LineSegmentInt lineSegmentInt) {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        if (this.getSegments().contains(lineSegmentInt)) {
            throw new IllegalArgumentException();
        }
        ClosedArea closedArea = new ClosedArea();
        for (LineSegmentInt lineSegmentInt2 : this.segmentsList) {
            closedArea.addSegment(lineSegmentInt2);
        }
        if (closedArea.getSegments().size() > 0 && !closedArea.getLastSegment().atLeastOneCommonExtremities(lineSegmentInt)) {
            throw new IllegalArgumentException();
        }
        if (this.points.contains(lineSegmentInt.getP1()) && this.points.contains(lineSegmentInt.getP2()) && !lineSegmentInt.getP1().equals(this.getFirstPoint()) && !lineSegmentInt.getP2().equals(this.getFirstPoint())) {
            return null;
        }
        closedArea.addSegment(lineSegmentInt);
        assert (closedArea.isConsistent());
        return closedArea;
    }

    public void addSegment(LineSegmentInt lineSegmentInt) {
        super.addSegment(lineSegmentInt);
        this.minY = Math.min(this.minY, lineSegmentInt.getMinY());
        this.maxY = Math.max(this.maxY, lineSegmentInt.getMaxY());
        this.minX = Math.min(this.minX, lineSegmentInt.getMinX());
        this.maxX = Math.max(this.maxX, lineSegmentInt.getMaxX());
        this.segmentsList.add(lineSegmentInt);
        if (this.points.size() == 0) {
            assert (this.getSegments().size() == 1);
            this.points.add(lineSegmentInt.getP1());
            this.points.add(lineSegmentInt.getP2());
        } else if (this.points.size() == 2) {
            assert (this.segmentsList.size() == 2);
            LineSegmentInt lineSegmentInt2 = this.segmentsList.get(0);
            LineSegmentInt lineSegmentInt3 = this.segmentsList.get(1);
            this.points.clear();
            Point2DInt point2DInt = lineSegmentInt2.getCommonExtremities(lineSegmentInt3);
            if (point2DInt == null) {
                throw new IllegalArgumentException();
            }
            assert (point2DInt.equals(lineSegmentInt3.getCommonExtremities(lineSegmentInt2)));
            this.points.add(lineSegmentInt2.getOtherExtremity(point2DInt));
            this.points.add(point2DInt);
            this.points.add(lineSegmentInt3.getOtherExtremity(point2DInt));
        } else {
            Point2DInt point2DInt = this.getLastPoint();
            this.points.add(lineSegmentInt.getOtherExtremity(point2DInt));
        }
        assert (this.isConsistent());
    }

    private Point2DInt getLastPoint() {
        return this.points.get(this.points.size() - 1);
    }

    private Point2DInt getFirstPoint() {
        return this.points.get(0);
    }

    public LineSegmentInt getLastSegment() {
        return this.segmentsList.get(this.segmentsList.size() - 1);
    }

    private LineSegmentInt getFirstSegment() {
        return this.segmentsList.get(0);
    }

    public Point2DInt getFreePoint() {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        return this.getLastPoint();
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public boolean contains(ClosedArea closedArea) {
        if (!this.isClosed()) {
            throw new IllegalStateException();
        }
        for (Point2DInt point2DInt : closedArea.points) {
            if (this.contains(point2DInt)) continue;
            return false;
        }
        return true;
    }

    boolean arePointsConnectable(Point2DInt point2DInt, Point2DInt point2DInt2) {
        boolean bl;
        if (this.isOnFrontier(point2DInt) || this.isOnFrontier(point2DInt2)) {
            return true;
        }
        boolean bl2 = this.contains(point2DInt);
        return bl2 == (bl = this.contains(point2DInt2));
    }
}

