/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.golem;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.SpriteContainerEmpty;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.golem.TileArea;
import znaishaded.net.sourceforge.plantuml.golem.TileGeometry;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorUtils;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class Tile
extends AbstractTextBlock
implements TextBlock {
    private static double SIZE = 40.0;
    private final int num;
    private final UFont numberFont = UFont.monospaced(11);
    private final FontConfiguration fc = FontConfiguration.blackBlueTrue(this.numberFont);
    private final Map<TileGeometry, TileArea> geometries;

    Tile(int n) {
        this.num = n;
        EnumMap<TileGeometry, TileArea> enumMap = new EnumMap<TileGeometry, TileArea>(TileGeometry.class);
        for (TileGeometry tileGeometry : TileGeometry.values()) {
            enumMap.put(tileGeometry, new TileArea(this, tileGeometry));
        }
        this.geometries = Collections.unmodifiableMap(enumMap);
    }

    public TileArea getArea(TileGeometry tileGeometry) {
        return this.geometries.get((Object)tileGeometry);
    }

    public void drawU(UGraphic uGraphic) {
        uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.BLACK));
        TextBlock textBlock = Display.create("" + this.num).create(this.fc, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        Dimension2D dimension2D = textBlock.calculateDimension(uGraphic.getStringBounder());
        Dimension2D dimension2D2 = this.calculateDimension(uGraphic.getStringBounder());
        double d = dimension2D2.getWidth() - dimension2D.getWidth();
        double d2 = dimension2D2.getHeight() - dimension2D.getHeight();
        double d3 = Math.max(dimension2D.getWidth(), dimension2D.getHeight());
        double d4 = dimension2D2.getWidth() - d3;
        double d5 = dimension2D2.getHeight() - d3;
        textBlock.drawU(uGraphic.apply(new UTranslate(d / 2.0, d2 / 2.0)));
        uGraphic.draw(new URectangle(SIZE, SIZE));
        uGraphic.apply(new UTranslate(d4 / 2.0, d5 / 2.0)).draw(new UEllipse(d3, d3));
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(SIZE, SIZE);
    }
}

