/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graph2;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.graph2.RectanglesCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyCurve {
    private final CubicCurve2D.Double curve;
    private final List<Line2D.Double> lines = new ArrayList<Line2D.Double>();
    private final List<Line2D.Double> linesForInters = new ArrayList<Line2D.Double>();
    private Color color = Color.GREEN;
    private double lenght = 0.0;

    public MyCurve(CubicCurve2D.Double double_) {
        this.curve = double_;
        this.addCurve(double_);
        if (this.lenght <= 0.0) {
            throw new IllegalStateException();
        }
        for (Line2D.Double double_2 : this.lines) {
            this.linesForInters.add(this.change(double_2, double_.getP1(), double_.getP2()));
        }
    }

    private Line2D.Double change(Line2D.Double double_, Point2D point2D, Point2D point2D2) {
        if (!double_.getP1().equals(point2D) && !double_.getP2().equals(point2D2)) {
            return double_;
        }
        double d = double_.x2 - double_.x1;
        double d2 = double_.y2 - double_.y1;
        point2D = double_.getP1().equals(point2D) ? new Point2D.Double(double_.x1 + d / 10.0, double_.y1 + d2 / 10.0) : double_.getP1();
        point2D2 = double_.getP2().equals(point2D2) ? new Point2D.Double(double_.x2 - d / 10.0, double_.y2 - d2 / 10.0) : double_.getP2();
        return new Line2D.Double(point2D, point2D2);
    }

    public final double getLenght() {
        return this.lenght;
    }

    private void addCurve(CubicCurve2D.Double double_) {
        Rectangle2D rectangle2D = double_.getBounds2D();
        double d = double_.getFlatness();
        if (d < 10.0) {
            this.lines.add(new Line2D.Double(double_.getP1(), double_.getP2()));
            this.lenght += Math.sqrt(rectangle2D.getWidth() * rectangle2D.getWidth() + rectangle2D.getHeight() * rectangle2D.getHeight());
            return;
        }
        CubicCurve2D.Double double_2 = new CubicCurve2D.Double();
        CubicCurve2D.Double double_3 = new CubicCurve2D.Double();
        double_.subdivide(double_2, double_3);
        this.addCurve(double_2);
        this.addCurve(double_3);
    }

    public void drawDebug(Graphics2D graphics2D) {
        for (Line2D line2D : this.linesForInters) {
            graphics2D.setColor(this.color);
            graphics2D.draw(line2D);
        }
        graphics2D.setColor(Color.BLACK);
    }

    public void draw(Graphics2D graphics2D) {
        graphics2D.setStroke(new BasicStroke(1.5f));
        graphics2D.draw(this.curve);
        graphics2D.setStroke(new BasicStroke());
    }

    public final void setColor(Color color) {
        this.color = color;
    }

    public boolean intersects(List<MyCurve> list) {
        for (MyCurve myCurve : list) {
            if (!this.intersects(myCurve)) continue;
            return true;
        }
        return false;
    }

    private boolean intersects(MyCurve myCurve) {
        for (Line2D.Double double_ : this.linesForInters) {
            for (Line2D.Double double_2 : myCurve.linesForInters) {
                if (!double_.intersectsLine(double_2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean intersects(RectanglesCollection rectanglesCollection) {
        for (Rectangle2D.Double double_ : rectanglesCollection) {
            for (Line2D.Double double_2 : this.lines) {
                if (!double_.intersectsLine(double_2)) continue;
                return true;
            }
        }
        return false;
    }
}

