/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.html;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.FileImageData;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IEntity;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LeafType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Link;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Member;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.html.LinkHtmlPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CucaDiagramHtmlMaker {
    private final CucaDiagram diagram;
    private final File dir;

    public CucaDiagramHtmlMaker(CucaDiagram cucaDiagram, File file) {
        this.diagram = cucaDiagram;
        this.dir = file;
    }

    public List<FileImageData> create() throws IOException {
        this.dir.mkdirs();
        if (!this.dir.exists()) {
            throw new IOException("Cannot create " + this.dir);
        }
        File file = new File(this.dir, "index.html");
        PrintWriter printWriter = new PrintWriter(file);
        printWriter.println("<html>");
        this.printAllType(printWriter, LeafType.ENUM);
        this.printAllType(printWriter, LeafType.INTERFACE);
        this.printAllType(printWriter, LeafType.ANNOTATION);
        this.printAllType(printWriter, LeafType.ABSTRACT_CLASS);
        this.printAllType(printWriter, LeafType.CLASS);
        this.htmlClose(printWriter);
        return Arrays.asList(new FileImageData(this.dir, null));
    }

    private void printAllType(PrintWriter printWriter, LeafType leafType) throws IOException {
        if (this.hasSome(leafType)) {
            printWriter.println("<h2>" + leafType.toHtml() + "</h2>");
            for (IEntity iEntity : this.diagram.getLeafsvalues()) {
                if (iEntity.getLeafType() != leafType) continue;
                this.export(iEntity);
                printWriter.println("<li>");
                printWriter.println(LinkHtmlPrinter.htmlLink(iEntity));
                printWriter.println("</li>");
            }
        }
    }

    private boolean hasSome(LeafType leafType) {
        for (IEntity iEntity : this.diagram.getLeafsvalues()) {
            if (iEntity.getLeafType() != leafType) continue;
            return true;
        }
        return false;
    }

    private void export(IEntity iEntity) throws IOException {
        Iterator<Member> iterator22;
        File file = new File(this.dir, LinkHtmlPrinter.urlOf(iEntity));
        PrintWriter printWriter = new PrintWriter(file);
        printWriter.println("<html>");
        printWriter.println("<title>" + StringUtils.unicodeForHtml(iEntity.getCode().getFullName()) + "</title>");
        printWriter.println("<h2>" + iEntity.getLeafType().toHtml() + "</h2>");
        for (Iterator<Member> iterator22 : iEntity.getDisplay()) {
            printWriter.println(StringUtils.unicodeForHtml(iterator22.toString()));
            printWriter.println("<br>");
        }
        Stereotype stereotype = iEntity.getStereotype();
        if (stereotype != null) {
            printWriter.println("<hr>");
            printWriter.println("<h3>Stereotype</h3>");
            for (String object22 : stereotype.getLabels(this.diagram.getSkinParam().useGuillemet())) {
                printWriter.println(object22);
                printWriter.println("<br>");
            }
        }
        printWriter.println("<hr>");
        if (iEntity.getBodier().getFieldsToDisplay().size() == 0) {
            printWriter.println("<h2>No fields</h2>");
        } else {
            printWriter.println("<h2>Fields:</h2>");
            printWriter.println("<ul>");
            for (Member member : iEntity.getBodier().getFieldsToDisplay()) {
                printWriter.println("<li>");
                printWriter.println(StringUtils.unicodeForHtml(member.getDisplay(true)));
                printWriter.println("</li>");
            }
            printWriter.println("</ul>");
        }
        printWriter.println("<hr>");
        if (iEntity.getBodier().getMethodsToDisplay().size() == 0) {
            printWriter.println("<h2>No methods</h2>");
        } else {
            printWriter.println("<h2>Methods:</h2>");
            printWriter.println("<ul>");
            for (Member member : iEntity.getBodier().getMethodsToDisplay()) {
                printWriter.println("<li>");
                printWriter.println(StringUtils.unicodeForHtml(member.getDisplay(true)));
                printWriter.println("</li>");
            }
            printWriter.println("</ul>");
        }
        printWriter.println("<hr>");
        iterator22 = this.getLinksButNotes(iEntity);
        if (iterator22.size() == 0) {
            printWriter.println("<h2>No links</h2>");
        } else {
            printWriter.println("<h2>Links:</h2>");
            printWriter.println("<ul>");
            Iterator iterator = iterator22.iterator();
            while (iterator.hasNext()) {
                Link link = (Link)iterator.next();
                printWriter.println("<li>");
                new LinkHtmlPrinter(link, iEntity).printLink(printWriter);
                printWriter.println("</li>");
            }
            printWriter.println("</ul>");
        }
        Collection<IEntity> collection = this.getNotes(iEntity);
        if (collection.size() > 0) {
            printWriter.println("<hr>");
            printWriter.println("<h2>Notes:</h2>");
            printWriter.println("<ul>");
            for (IEntity iEntity2 : collection) {
                printWriter.println("<li>");
                for (CharSequence charSequence : iEntity2.getDisplay()) {
                    printWriter.println(StringUtils.unicodeForHtml(charSequence.toString()));
                    printWriter.println("<br>");
                }
                printWriter.println("</li>");
            }
            printWriter.println("</ul>");
        }
        this.htmlClose(printWriter);
    }

    private void htmlClose(PrintWriter printWriter) {
        printWriter.println("<hr>");
        printWriter.println("<a href=index.html>Back to index</a>");
        printWriter.println("</html>");
        printWriter.close();
    }

    private Collection<IEntity> getNotes(IEntity iEntity) {
        ArrayList<IEntity> arrayList = new ArrayList<IEntity>();
        for (Link link : this.diagram.getLinks()) {
            if (!link.contains(iEntity) || link.getEntity1().getLeafType() != LeafType.NOTE && link.getEntity2().getLeafType() != LeafType.NOTE) continue;
            arrayList.add(link.getOther(iEntity));
        }
        return Collections.unmodifiableList(arrayList);
    }

    private Collection<Link> getLinksButNotes(IEntity iEntity) {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        for (Link link : this.diagram.getLinks()) {
            if (!link.contains(iEntity) || link.getEntity1().getLeafType() == LeafType.NOTE || link.getEntity2().getLeafType() == LeafType.NOTE) continue;
            arrayList.add(link);
        }
        return Collections.unmodifiableList(arrayList);
    }
}

