/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.posimo;

import java.awt.geom.Dimension2D;
import java.util.Collection;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.posimo.Block;
import znaishaded.net.sourceforge.plantuml.posimo.Cluster;
import znaishaded.net.sourceforge.plantuml.posimo.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotxMaker {
    private final Cluster root;
    private final Collection<Path> paths;

    public DotxMaker(Cluster cluster, Collection<Path> collection) {
        this.root = cluster;
        this.paths = collection;
    }

    public String createDotString(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("digraph unix {");
        for (String string : stringArray) {
            stringBuilder.append(string);
        }
        stringBuilder.append("compound=true;");
        this.printCluster(stringBuilder, this.root);
        for (Path path2 : this.paths) {
            stringBuilder.append(this.getPathString(path2) + ";");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private void printCluster(StringBuilder stringBuilder, Cluster cluster) {
        if (cluster.getContents().size() == 0 && cluster.getSubClusters().size() == 0) {
            throw new IllegalStateException(cluster.toString());
        }
        for (Cluster clusterable : cluster.getSubClusters()) {
            stringBuilder.append("subgraph cluster" + clusterable.getUid() + " {");
            if (clusterable.getTitleWidth() > 0.0 && clusterable.getTitleHeight() > 0.0) {
                stringBuilder.append("label=<<TABLE FIXEDSIZE=\"TRUE\" WIDTH=\"" + clusterable.getTitleWidth() + "\" HEIGHT=\"" + clusterable.getTitleHeight() + "\"><TR><TD></TD></TR></TABLE>>");
            }
            this.printCluster(stringBuilder, clusterable);
            stringBuilder.append("}");
        }
        for (Block block2 : cluster.getContents()) {
            stringBuilder.append("b" + block2.getUid() + this.getNodeAttibute(block2) + ";");
        }
    }

    private String getPathString(Path path2) {
        if (path2 == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder stringBuilder = new StringBuilder("b" + path2.getStart().getUid() + " -> b" + path2.getEnd().getUid());
        stringBuilder.append(" [dir=none, arrowhead=none, headclip=true, tailclip=true");
        int n = path2.getLength();
        if (n >= 3) {
            stringBuilder.append(",minlen=" + (n - 1));
        }
        if (path2.getLabel() == null) {
            stringBuilder.append("]");
        } else {
            Dimension2D dimension2D = path2.getLabel().getSize();
            stringBuilder.append(", label=<<TABLE FIXEDSIZE=\"TRUE\" WIDTH=\"" + dimension2D.getWidth() + "\" HEIGHT=\"" + dimension2D.getHeight() + "\"><TR><TD></TD></TR></TABLE>>]");
        }
        if (path2.getLength() <= 1) {
            boolean bl;
            boolean bl2 = bl = path2.getStart().getParent() == path2.getEnd().getParent();
            if (bl) {
                stringBuilder.append("{rank=same; b" + path2.getStart().getUid() + "; b" + path2.getEnd().getUid() + "}");
            } else {
                Log.println("!!!!!!!!!!!!!!!!!TURNING ARROUND DOT BUG!!!!!!!!!!!!!!!!!!");
            }
        }
        return stringBuilder.toString();
    }

    private String getNodeAttibute(Block block2) {
        StringBuilder stringBuilder = new StringBuilder("[");
        stringBuilder.append("label=\"\",");
        stringBuilder.append("fixedsize=true,");
        stringBuilder.append("width=" + block2.getSize().getWidth() / 72.0 + ",");
        stringBuilder.append("height=" + block2.getSize().getHeight() / 72.0 + ",");
        stringBuilder.append("shape=rect");
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

