/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.graphic;

import java.util.Map;
import java.util.SortedMap;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorSetSimple;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorUtils;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.project.Instant;
import znaishaded.net.sourceforge.plantuml.project.Item;
import znaishaded.net.sourceforge.plantuml.project.Jalon;
import znaishaded.net.sourceforge.plantuml.project.Project;
import znaishaded.net.sourceforge.plantuml.project.graphic.ItemHeader;
import znaishaded.net.sourceforge.plantuml.project.graphic.TimeScale;
import znaishaded.net.sourceforge.plantuml.ugraphic.AbstractShadowable;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GanttDiagramUnused {
    private final Project project;
    private final TimeScale timeScale;
    private final ItemHeader itemHeader;
    private final HtmlColor lightGray = new HtmlColorSetSimple().getColorIfValid("#C8C8C8");

    public GanttDiagramUnused(Project project) {
        this.project = project;
        this.timeScale = new TimeScale(project);
        this.itemHeader = new ItemHeader(project);
    }

    public void draw(UGraphic uGraphic, double d, double d2) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d3 = this.itemHeader.getWidth(stringBounder);
        double d4 = this.timeScale.getHeight(stringBounder);
        SortedMap<Instant, Double> sortedMap = this.timeScale.getAbscisse(stringBounder);
        for (Item item2 : this.project.getValidItems()) {
            AbstractShadowable abstractShadowable;
            Instant instant = item2.getBegin();
            Instant instant2 = item2.getCompleted();
            if (sortedMap.get(instant) == null || sortedMap.get(instant2) == null) {
                Log.println("PB " + item2);
                continue;
            }
            double d5 = (Double)sortedMap.get(instant) + 3.0;
            double d6 = (Double)sortedMap.get(instant2) - 3.0;
            double d7 = d4 + this.itemHeader.getPosition(stringBounder, item2) + 3.0;
            if (item2 instanceof Jalon) {
                abstractShadowable = new UPolygon();
                ((UPolygon)abstractShadowable).addPoint(0.0, 3.0);
                ((UPolygon)abstractShadowable).addPoint(3.0, 0.0);
                ((UPolygon)abstractShadowable).addPoint(6.0, 3.0);
                ((UPolygon)abstractShadowable).addPoint(3.0, 6.0);
            } else {
                abstractShadowable = new URectangle(d6 - d5, 3.0);
            }
            uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.GREEN));
            uGraphic = uGraphic.apply(new UChangeBackColor(HtmlColorUtils.GRAY));
            uGraphic.apply(new UTranslate(d3 + d5, d7)).draw(abstractShadowable);
        }
        this.drawGrid(uGraphic, d + d3, d2 + d4, sortedMap);
        uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.BLACK));
        uGraphic = uGraphic.apply(new UChangeBackColor(null));
        this.timeScale.draw(uGraphic, d + d3, d2);
        this.itemHeader.draw(uGraphic, d, d2 + d4);
    }

    private void drawGrid(UGraphic uGraphic, double d, double d2, SortedMap<Instant, Double> sortedMap) {
        ULine uLine = new ULine(0.0, this.itemHeader.getHeight(uGraphic.getStringBounder()));
        Instant instant = null;
        for (Map.Entry<Instant, Double> entry : sortedMap.entrySet()) {
            double d3 = entry.getValue();
            uGraphic = instant == null || instant.next(null).equals(entry.getKey()) ? uGraphic.apply(new UChangeColor(this.lightGray)) : uGraphic.apply(new UChangeColor(HtmlColorUtils.BLACK));
            uGraphic.apply(new UTranslate(d + d3, d2)).draw(uLine);
            instant = entry.getKey();
        }
    }

    public double getWidth(StringBounder stringBounder) {
        return this.itemHeader.getWidth(stringBounder) + this.timeScale.getWidth(stringBounder) + 3.0;
    }

    public double getHeight(StringBounder stringBounder) {
        return this.itemHeader.getHeight(stringBounder) + this.timeScale.getHeight(stringBounder) + 3.0;
    }
}

