/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.real;

import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.real.RealMoveable;

class PositiveForce {
    private final Real fixedPoint;
    private final RealMoveable movingPoint;
    private final double minimunDistance;
    private final boolean trace = false;
    private final Throwable creationPoint;

    public PositiveForce(Real real, RealMoveable realMoveable, double d) {
        if (real == realMoveable) {
            throw new IllegalArgumentException();
        }
        this.fixedPoint = real;
        this.movingPoint = realMoveable;
        this.minimunDistance = d;
        this.creationPoint = new Throwable();
        this.creationPoint.fillInStackTrace();
    }

    public String toString() {
        return "PositiveForce fixed=" + this.fixedPoint + " moving=" + this.movingPoint + " min=" + this.minimunDistance;
    }

    public boolean apply() {
        double d;
        double d2 = this.movingPoint.getCurrentValue();
        try {
            d = this.fixedPoint.getCurrentValue();
        }
        catch (IllegalStateException illegalStateException) {
            System.err.println("Pb with force " + this);
            System.err.println("This force has been created here:");
            this.creationPoint.printStackTrace();
            System.err.println("The fixed point has been created here: " + this.fixedPoint);
            this.fixedPoint.printCreationStackTrace();
            throw illegalStateException;
        }
        double d3 = d2 - d;
        double d4 = d3 - this.minimunDistance;
        if (d4 >= 0.0) {
            return false;
        }
        this.movingPoint.move(-d4);
        return true;
    }
}

