/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.real.RealUtils;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Event;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Grouping;
import znaishaded.net.sourceforge.plantuml.sequencediagram.GroupingLeaf;
import znaishaded.net.sourceforge.plantuml.sequencediagram.GroupingStart;
import znaishaded.net.sourceforge.plantuml.sequencediagram.GroupingType;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.ElseTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LiveBoxFinder;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.TileBuilder;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.TileWithCallbackY;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.YPositionedTile;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.Component;
import znaishaded.net.sourceforge.plantuml.skin.ComponentType;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.skin.Skin;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupingTile
implements TileWithCallbackY {
    private static final int EXTERNAL_MARGINX1 = 3;
    private static final int EXTERNAL_MARGINX2 = 9;
    private static final int MARGINX = 16;
    private static final int MARGINY = 10;
    private final List<Tile> tiles = new ArrayList<Tile>();
    private final Real min;
    private final Real max;
    private final GroupingStart start;
    private final Skin skin;
    private final ISkinParam skinParam;
    private final Display display;
    private double bodyHeight;
    private double y;

    @Override
    public Event getEvent() {
        return this.start;
    }

    public GroupingTile(Iterator<Event> iterator, GroupingStart groupingStart, TileArguments tileArguments, TileArguments tileArguments2) {
        Object object;
        StringBounder stringBounder = tileArguments2.getStringBounder();
        this.start = groupingStart;
        this.display = groupingStart.getTitle().equals("group") ? Display.create(groupingStart.getComment()) : Display.create(groupingStart.getTitle(), groupingStart.getComment());
        this.skin = tileArguments2.getSkin();
        this.skinParam = tileArguments.getSkinParam();
        ArrayList<Real> arrayList = new ArrayList<Real>();
        ArrayList<Real> arrayList2 = new ArrayList<Real>();
        ArrayList<Tile> arrayList3 = new ArrayList<Tile>();
        while (iterator.hasNext() && (!((object = iterator.next()) instanceof GroupingLeaf) || ((Grouping)object).getType() != GroupingType.END)) {
            for (Tile tile : TileBuilder.buildOne(iterator, tileArguments2, (Event)object, this)) {
                this.tiles.add(tile);
                this.bodyHeight += tile.getPreferredHeight(stringBounder);
                if (object instanceof GroupingLeaf && ((Grouping)object).getType() == GroupingType.ELSE) {
                    arrayList3.add(tile);
                    continue;
                }
                arrayList.add(tile.getMinX(stringBounder).addFixed(-16.0));
                Real real = tile.getMaxX(stringBounder);
                arrayList2.add(real.addFixed(16.0));
            }
        }
        object = this.getPreferredDimensionIfEmpty(stringBounder);
        double d = ((Dimension2D)object).getWidth();
        if (arrayList.size() == 0) {
            arrayList.add(tileArguments2.getOrigin());
        }
        this.min = RealUtils.min(arrayList);
        for (Tile tile : arrayList3) {
            arrayList2.add(tile.getMaxX(stringBounder));
        }
        arrayList2.add(this.min.addFixed(d + 16.0));
        this.max = RealUtils.max(arrayList2);
    }

    private Component getComponent(StringBounder stringBounder) {
        Component component = this.skin.createComponent(ComponentType.GROUPING_HEADER, null, this.skinParam, this.display);
        return component;
    }

    private Dimension2D getPreferredDimensionIfEmpty(StringBounder stringBounder) {
        return this.getComponent(stringBounder).getPreferredDimension(stringBounder);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = this.getPreferredDimensionIfEmpty(stringBounder);
        Area area = new Area(this.max.getCurrentValue() - this.min.getCurrentValue(), this.getTotalHeight(stringBounder));
        if (!(uGraphic instanceof LiveBoxFinder)) {
            component.drawU(uGraphic.apply(new UTranslate(this.min.getCurrentValue(), 0.0)), area, (Context2D)((Object)uGraphic));
            this.drawAllElses(uGraphic);
        }
        double d = dimension2D.getHeight() + 5.0;
        for (Tile tile : this.tiles) {
            uGraphic.apply(new UTranslate(0.0, d)).draw(tile);
            d += tile.getPreferredHeight(stringBounder);
        }
    }

    private double getTotalHeight(StringBounder stringBounder) {
        Dimension2D dimension2D = this.getPreferredDimensionIfEmpty(stringBounder);
        return this.bodyHeight + dimension2D.getHeight() + 5.0;
    }

    private void drawAllElses(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d = this.getTotalHeight(stringBounder);
        double d2 = this.getPreferredDimensionIfEmpty(stringBounder).getHeight() + 5.0;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (Tile object : this.tiles) {
            if (!(object instanceof ElseTile)) continue;
            Tile tile = (ElseTile)object;
            arrayList.add(((ElseTile)tile).getCallbackY() - this.y + d2);
        }
        arrayList.add(d);
        int n = 0;
        for (Tile tile : this.tiles) {
            if (!(tile instanceof ElseTile)) continue;
            Tile tile2 = tile;
            Component component = ((ElseTile)tile2).getComponent(stringBounder);
            Area area = new Area(this.max.getCurrentValue() - this.min.getCurrentValue(), (Double)arrayList.get(n + 1) - (Double)arrayList.get(n));
            component.drawU(uGraphic.apply(new UTranslate(this.min.getCurrentValue(), (Double)arrayList.get(n))), area, (Context2D)((Object)uGraphic));
            ++n;
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        Dimension2D dimension2D = this.getPreferredDimensionIfEmpty(stringBounder);
        return dimension2D.getHeight() + this.bodyHeight + 10.0;
    }

    @Override
    public void addConstraints(StringBounder stringBounder) {
        for (Tile tile : this.tiles) {
            tile.addConstraints(stringBounder);
        }
    }

    @Override
    public Real getMinX(StringBounder stringBounder) {
        return this.min.addFixed(-3.0);
    }

    @Override
    public Real getMaxX(StringBounder stringBounder) {
        return this.max.addFixed(9.0);
    }

    @Override
    public void callbackY(double d) {
        this.y = d;
    }

    public static double fillPositionelTiles(StringBounder stringBounder, double d, List<Tile> list, List<YPositionedTile> list2) {
        double d2 = d;
        for (Tile tile : list) {
            if (tile.getEvent().isParallel()) {
                d = d2;
            }
            list2.add(new YPositionedTile(tile, d));
            if (tile instanceof GroupingTile) {
                GroupingTile groupingTile = (GroupingTile)tile;
                GroupingTile.fillPositionelTiles(stringBounder, d, groupingTile.tiles, new ArrayList<YPositionedTile>());
            }
            d2 = d;
            d += tile.getPreferredHeight(stringBounder);
        }
        return d;
    }
}

