/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.LineConfigurable;
import znaishaded.net.sourceforge.plantuml.LineParam;
import znaishaded.net.sourceforge.plantuml.SkinParamUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.creole.Stencil;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.EntityPortion;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.PortionShower;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockEmpty;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockLineBefore;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.ugraphic.PlacementStrategyY1Y2;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULayoutGroup;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageObject
extends AbstractEntityImage
implements Stencil {
    private final TextBlock name;
    private final TextBlock stereo;
    private final TextBlock fields;
    private final Url url;
    private final double roundCorner;
    private final LineConfigurable lineConfig;
    private int marginEmptyFieldsOrMethod = 13;
    private int xMarginCircle = 5;

    public EntityImageObject(ILeaf iLeaf, ISkinParam iSkinParam, PortionShower portionShower) {
        super(iLeaf, iSkinParam);
        this.lineConfig = iLeaf;
        Stereotype stereotype = iLeaf.getStereotype();
        this.roundCorner = iSkinParam.getRoundCorner("", null);
        this.name = TextBlockUtils.withMargin(iLeaf.getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.OBJECT, stereotype), HorizontalAlignment.CENTER, iSkinParam), 2.0, 2.0);
        this.stereo = stereotype == null || stereotype.getLabel(false) == null || !portionShower.showPortion(EntityPortion.STEREOTYPE, iLeaf) ? null : Display.create(stereotype.getLabels(iSkinParam.useGuillemet())).create(new FontConfiguration(this.getSkinParam(), FontParam.OBJECT_STEREOTYPE, stereotype), HorizontalAlignment.CENTER, iSkinParam);
        boolean bl = portionShower.showPortion(EntityPortion.FIELD, iLeaf);
        this.fields = iLeaf.getBodier().getFieldsToDisplay().size() == 0 ? new TextBlockLineBefore(new TextBlockEmpty(10.0, 16.0)) : iLeaf.getBodier().getBody(FontParam.OBJECT_ATTRIBUTE, iSkinParam, false, bl, iLeaf.getStereotype());
        this.url = iLeaf.getUrl99();
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.getTitleDimension(stringBounder);
        Dimension2D dimension2D2 = this.fields.calculateDimension(stringBounder);
        double d = Math.max(dimension2D2.getWidth(), dimension2D.getWidth() + (double)(2 * this.xMarginCircle));
        double d2 = this.getMethodOrFieldHeight(dimension2D2) + dimension2D.getHeight();
        return new Dimension2DDouble(d, d2);
    }

    public final void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.getTitleDimension(stringBounder);
        double d = dimension2D.getWidth();
        double d2 = dimension2D.getHeight();
        URectangle uRectangle = new URectangle(d, d2, this.roundCorner, this.roundCorner);
        if (this.getSkinParam().shadowing()) {
            uRectangle.setDeltaShadow(4.0);
        }
        uGraphic = uGraphic.apply(new UChangeColor(SkinParamUtils.getColor(this.getSkinParam(), ColorParam.objectBorder, this.getStereo())));
        HtmlColor htmlColor = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.BACK);
        if (htmlColor == null) {
            htmlColor = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.objectBackground, this.getStereo());
        }
        uGraphic = uGraphic.apply(new UChangeBackColor(htmlColor));
        if (this.url != null) {
            uGraphic.startUrl(this.url);
        }
        UStroke uStroke = this.getStroke();
        uGraphic.apply(uStroke).draw(uRectangle);
        ULayoutGroup uLayoutGroup = new ULayoutGroup(new PlacementStrategyY1Y2(uGraphic.getStringBounder()));
        if (this.stereo != null) {
            uLayoutGroup.add(this.stereo);
        }
        uLayoutGroup.add(this.name);
        uLayoutGroup.drawU(uGraphic, dimension2D.getWidth(), dimension2D2.getHeight());
        UGraphic uGraphic2 = UGraphicStencil.create(uGraphic, this, uStroke);
        this.fields.drawU(uGraphic2.apply(new UTranslate(0.0, dimension2D2.getHeight())));
        if (this.url != null) {
            uGraphic.closeAction();
        }
    }

    private UStroke getStroke() {
        UStroke uStroke = this.lineConfig.getColors(this.getSkinParam()).getSpecificLineStroke();
        if (uStroke == null) {
            uStroke = this.getSkinParam().getThickness(LineParam.objectBorder, this.getStereo());
        }
        if (uStroke == null) {
            uStroke = new UStroke(1.5);
        }
        return uStroke;
    }

    private double getMethodOrFieldHeight(Dimension2D dimension2D) {
        double d = dimension2D.getHeight();
        if (d == 0.0) {
            return this.marginEmptyFieldsOrMethod;
        }
        return d;
    }

    private Dimension2D getTitleDimension(StringBounder stringBounder) {
        return this.getNameAndSteretypeDimension(stringBounder);
    }

    private Dimension2D getNameAndSteretypeDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.name.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.stereo == null ? new Dimension2DDouble(0.0, 0.0) : this.stereo.calculateDimension(stringBounder);
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(Math.max(dimension2D.getWidth(), dimension2D2.getWidth()), dimension2D.getHeight() + dimension2D2.getHeight());
        return dimension2DDouble;
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public double getStartingX(StringBounder stringBounder, double d) {
        return 0.0;
    }

    public double getEndingX(StringBounder stringBounder, double d) {
        return this.calculateDimension(stringBounder).getWidth();
    }
}

