/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import znaishaded.net.sourceforge.plantuml.swing.LicenseWindow;
import znaishaded.net.sourceforge.plantuml.version.PSystemVersion;
import znaishaded.net.sourceforge.plantuml.version.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AboutWindow
extends JFrame {
    public AboutWindow() {
        this.setIconImage(PSystemVersion.getPlantumlSmallIcon2());
        this.setTitle("About PlantUML (" + Version.versionString() + ")");
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        jPanel.add(this.getInfoVersion());
        jPanel.add(this.getInfoAuthors());
        this.getContentPane().add((Component)this.getNorthLabel(), "North");
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)this.getSouthLabel(), "South");
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
    }

    private JComponent getNorthLabel() {
        JLabel jLabel = new JLabel("PlantUML (" + Version.versionString() + ")");
        Font font = jLabel.getFont().deriveFont(1, 20.0f);
        jLabel.setFont(font);
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        JLabel jLabel2 = new JLabel(new ImageIcon(PSystemVersion.getPlantumlImage()));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)jLabel2, "East");
        return jPanel2;
    }

    private JComponent getSouthLabel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("License");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new LicenseWindow();
            }
        });
        JButton jButton2 = new JButton("OK");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AboutWindow.this.dispose();
            }
        });
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    private JComponent getInfoVersion() {
        PSystemVersion pSystemVersion = PSystemVersion.createShowVersion();
        return this.getJComponent(this.skip(pSystemVersion.getLines()));
    }

    private JComponent getInfoAuthors() {
        PSystemVersion pSystemVersion = PSystemVersion.createShowAuthors();
        return this.getJComponent(this.skip(pSystemVersion.getLines()));
    }

    private List<String> skip(List<String> list) {
        return list.subList(2, list.size());
    }

    private JComponent getJComponent(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder("<html>");
        for (String object2 : list) {
            stringBuilder.append(object2 + "</b></i></u>");
            stringBuilder.append("<br>");
        }
        stringBuilder.append("</html>");
        JEditorPane jEditorPane = new JEditorPane("text/html", stringBuilder.toString());
        jEditorPane.setEditable(false);
        CompoundBorder compoundBorder2 = new CompoundBorder(BorderFactory.createEtchedBorder(0), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        compoundBorder2 = new CompoundBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, this.getBackground()), compoundBorder2);
        jEditorPane.setBorder(compoundBorder2);
        return jEditorPane;
    }

    public static void main(String[] stringArray) {
        new AboutWindow();
    }
}

