/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.timingdiagram;

import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.timingdiagram.Player;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimeTick;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimeTickBuilder;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimingDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandTimeMessage
extends SingleLineCommand2<TimingDiagram> {
    public static final String PLAYER_CODE = "([\\p{L}_][\\p{L}0-9_.]*)";

    public CommandTimeMessage() {
        super(CommandTimeMessage.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("PART1", PLAYER_CODE), TimeTickBuilder.optionalExpressionAtWithArobase("TIME1"), new RegexLeaf("[%s]*"), new RegexLeaf("ARROW", "(-+)\\>"), new RegexLeaf("[%s]*"), new RegexLeaf("PART2", PLAYER_CODE), TimeTickBuilder.optionalExpressionAtWithArobase("TIME2"), new RegexLeaf("[%s]*"), new RegexLeaf("MESSAGE", "(?::[%s]*(.*))?"), new RegexLeaf("[%s]*$"));
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram timingDiagram, RegexResult regexResult) {
        Player player = timingDiagram.getPlayer(regexResult.get("PART1", 0));
        Player player2 = timingDiagram.getPlayer(regexResult.get("PART2", 0));
        TimeTick timeTick = TimeTickBuilder.parseTimeTick("TIME1", regexResult, timingDiagram);
        TimeTick timeTick2 = TimeTickBuilder.parseTimeTick("TIME2", regexResult, timingDiagram);
        timingDiagram.createTimeMessage(player, timeTick, player2, timeTick2, regexResult.get("MESSAGE", 0));
        return CommandExecutionResult.ok();
    }
}

