/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.tikz;

import java.io.IOException;
import java.io.OutputStream;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.creole.AtomText;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.posimo.DotPath;
import znaishaded.net.sourceforge.plantuml.tikz.TikzGraphics;
import znaishaded.net.sourceforge.plantuml.ugraphic.AbstractCommonUGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.AbstractUGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ClipContainer;
import znaishaded.net.sourceforge.plantuml.ugraphic.ColorMapper;
import znaishaded.net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic2;
import znaishaded.net.sourceforge.plantuml.ugraphic.UImage;
import znaishaded.net.sourceforge.plantuml.ugraphic.UImageSvg;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPath;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UText;
import znaishaded.net.sourceforge.plantuml.ugraphic.tikz.DriverAtomTextTikz;
import znaishaded.net.sourceforge.plantuml.ugraphic.tikz.DriverCenteredCharacterTikz;
import znaishaded.net.sourceforge.plantuml.ugraphic.tikz.DriverDotPathTikz;
import znaishaded.net.sourceforge.plantuml.ugraphic.tikz.DriverEllipseTikz;
import znaishaded.net.sourceforge.plantuml.ugraphic.tikz.DriverLineTikz;
import znaishaded.net.sourceforge.plantuml.ugraphic.tikz.DriverNoneTikz;
import znaishaded.net.sourceforge.plantuml.ugraphic.tikz.DriverPolygonTikz;
import znaishaded.net.sourceforge.plantuml.ugraphic.tikz.DriverRectangleTikz;
import znaishaded.net.sourceforge.plantuml.ugraphic.tikz.DriverUPathTikz;
import znaishaded.net.sourceforge.plantuml.ugraphic.tikz.DriverUTextTikz;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UGraphicTikz
extends AbstractUGraphic<TikzGraphics>
implements ClipContainer,
UGraphic2 {
    private final StringBounder stringBounder;

    private UGraphicTikz(ColorMapper colorMapper, TikzGraphics tikzGraphics) {
        super(colorMapper, tikzGraphics);
        this.stringBounder = FileFormat.PNG.getDefaultStringBounder();
        this.register();
    }

    public UGraphicTikz(ColorMapper colorMapper, double d, boolean bl) {
        this(colorMapper, new TikzGraphics(d, bl));
    }

    @Override
    protected AbstractCommonUGraphic copyUGraphic() {
        return new UGraphicTikz(this);
    }

    private UGraphicTikz(UGraphicTikz uGraphicTikz) {
        super(uGraphicTikz);
        this.stringBounder = uGraphicTikz.stringBounder;
        this.register();
    }

    private void register() {
        this.registerDriver(URectangle.class, new DriverRectangleTikz());
        this.registerDriver(UText.class, new DriverUTextTikz());
        this.registerDriver(AtomText.class, new DriverAtomTextTikz());
        this.registerDriver(ULine.class, new DriverLineTikz());
        this.registerDriver(UPolygon.class, new DriverPolygonTikz());
        this.registerDriver(UEllipse.class, new DriverEllipseTikz());
        this.registerDriver(UImage.class, new DriverNoneTikz());
        this.registerDriver(UImageSvg.class, new DriverNoneTikz());
        this.registerDriver(UPath.class, new DriverUPathTikz());
        this.registerDriver(DotPath.class, new DriverDotPathTikz());
        this.registerDriver(UCenteredCharacter.class, new DriverCenteredCharacterTikz());
    }

    @Override
    public StringBounder getStringBounder() {
        return this.stringBounder;
    }

    @Override
    public void startUrl(Url url) {
        ((TikzGraphics)this.getGraphicObject()).openLink(url.getUrl(), url.getTooltip());
    }

    @Override
    public void closeAction() {
        ((TikzGraphics)this.getGraphicObject()).closeLink();
    }

    @Override
    public void writeImageTOBEMOVED(OutputStream outputStream, String string, int n) throws IOException {
        this.createTikz(outputStream);
    }

    public void createTikz(OutputStream outputStream) throws IOException {
        ((TikzGraphics)this.getGraphicObject()).createData(outputStream);
    }

    @Override
    public boolean matchesProperty(String string) {
        return "SPECIALTXT".equalsIgnoreCase(string);
    }
}

