/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.visio;

import java.io.IOException;
import java.io.OutputStream;
import znaishaded.net.sourceforge.plantuml.ugraphic.visio.VisioShape;

public class VisioRectangle
implements VisioShape {
    private final int id;
    private final double x;
    private final double y;
    private final double width;
    private final double height;

    public static VisioRectangle createInches(int n, double d, double d2, double d3, double d4) {
        return new VisioRectangle(n, VisioRectangle.toInches(d), VisioRectangle.toInches(d2), VisioRectangle.toInches(d3), VisioRectangle.toInches(d4));
    }

    private VisioRectangle(int n, double d, double d2, double d3, double d4) {
        if (d < 0.0 || d2 < 0.0 || d3 < 0.0 || d4 < 0.0) {
            // empty if block
        }
        this.id = n;
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
    }

    public VisioShape yReverse(double d) {
        double d2 = d - (this.y + this.height);
        return new VisioRectangle(this.id, this.x, d2, this.width, this.height);
    }

    private static double toInches(double d) {
        return d / 72.0;
    }

    public void print(OutputStream outputStream) throws IOException {
        this.out(outputStream, "<Shape ID='" + this.id + "' Type='Shape' LineStyle='3' FillStyle='3' TextStyle='3'>");
        this.out(outputStream, "<XForm>");
        this.out(outputStream, "<PinX>" + (this.x + this.width / 2.0) + "</PinX>");
        this.out(outputStream, "<PinY>" + (this.y + this.height / 2.0) + "</PinY>");
        this.out(outputStream, "<Width>" + this.width + "</Width>");
        this.out(outputStream, "<Height>" + this.height + "</Height>");
        this.out(outputStream, "<Angle>0</Angle>");
        this.out(outputStream, "<FlipX>0</FlipX>");
        this.out(outputStream, "<FlipY>0</FlipY>");
        this.out(outputStream, "<ResizeMode>0</ResizeMode>");
        this.out(outputStream, "</XForm>");
        this.out(outputStream, "<Geom IX='0'>");
        this.out(outputStream, "<NoFill>0</NoFill>");
        this.out(outputStream, "<NoLine>0</NoLine>");
        this.out(outputStream, "<NoShow>0</NoShow>");
        this.out(outputStream, "<NoSnap>0</NoSnap>");
        this.out(outputStream, "<MoveTo IX='1'>");
        this.out(outputStream, "<X F='Width*0'>0</X>");
        this.out(outputStream, "<Y F='Height*0'>0</Y>");
        this.out(outputStream, "</MoveTo>");
        this.out(outputStream, "<LineTo IX='2'>");
        this.out(outputStream, "<X F='Width*1'>" + this.width + "</X>");
        this.out(outputStream, "<Y F='Height*0'>0</Y>");
        this.out(outputStream, "</LineTo>");
        this.out(outputStream, "<LineTo IX='3'>");
        this.out(outputStream, "<X F='Width*1'>" + this.width + "</X>");
        this.out(outputStream, "<Y F='Height*1'>" + this.height + "</Y>");
        this.out(outputStream, "</LineTo>");
        this.out(outputStream, "<LineTo IX='4'>");
        this.out(outputStream, "<X F='Width*0'>0</X>");
        this.out(outputStream, "<Y F='Height*1'>" + this.height + "</Y>");
        this.out(outputStream, "</LineTo>");
        this.out(outputStream, "<LineTo IX='5'>");
        this.out(outputStream, "<X F='Geometry1.X1'>0</X>");
        this.out(outputStream, "<Y F='Geometry1.Y1'>0</Y>");
        this.out(outputStream, "</LineTo>");
        this.out(outputStream, "</Geom>");
        this.out(outputStream, "</Shape>");
    }

    private void out(OutputStream outputStream, String string) throws IOException {
        outputStream.write(string.getBytes());
        outputStream.write("\n".getBytes());
    }
}

