/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.apache.ant.compress.resources;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Map;
import znaishaded.org.apache.ant.compress.util.ArchiveStreamFactory;
import znaishaded.org.apache.ant.compress.util.Messages;
import znaishaded.org.apache.ant.compress.util.StreamHelper;
import znaishaded.org.apache.commons.compress.archivers.ArchiveEntry;
import znaishaded.org.apache.commons.compress.archivers.ArchiveInputStream;
import znaishaded.org.apache.tools.ant.BuildException;
import znaishaded.org.apache.tools.ant.Project;
import znaishaded.org.apache.tools.ant.types.ArchiveScanner;
import znaishaded.org.apache.tools.ant.types.Resource;
import znaishaded.org.apache.tools.ant.util.FileUtils;

public class CommonsCompressArchiveScanner
extends ArchiveScanner {
    private final ArchiveStreamFactory factory;
    private final ResourceBuilder builder;
    private final boolean skipUnreadable;
    private final Project project;

    public CommonsCompressArchiveScanner(ArchiveStreamFactory factory, ResourceBuilder builder) {
        this(factory, builder, false, null);
    }

    public CommonsCompressArchiveScanner(ArchiveStreamFactory factory, ResourceBuilder builder, boolean skipUnreadableEntries, Project project) {
        this.factory = factory;
        this.builder = builder;
        this.skipUnreadable = skipUnreadableEntries;
        this.project = project;
    }

    public boolean getSkipUnreadableEntries() {
        return this.skipUnreadable;
    }

    protected void fillMapsFromArchive(Resource src, String encoding, Map fileEntries, Map matchFileEntries, Map dirEntries, Map matchDirEntries) {
        ArchiveEntry entry = null;
        ArchiveInputStream ai = null;
        try {
            try {
                ai = StreamHelper.getInputStream(this.factory, src, encoding);
                if (ai == null) {
                    ai = this.factory.getArchiveStream(new BufferedInputStream(src.getInputStream()), encoding);
                }
            }
            catch (IOException ex) {
                throw new BuildException("problem opening " + src, ex);
            }
            while ((entry = ai.getNextEntry()) != null) {
                if (this.skipUnreadable && !ai.canReadEntryData(entry)) {
                    this.log(Messages.skippedIsUnreadable(entry));
                    continue;
                }
                Resource r = this.builder.buildResource(src, encoding, entry);
                String name = entry.getName();
                if (entry.isDirectory()) {
                    name = CommonsCompressArchiveScanner.trimSeparator(name);
                    dirEntries.put(name, r);
                    if (!this.match(name)) continue;
                    matchDirEntries.put(name, r);
                    continue;
                }
                fileEntries.put(name, r);
                if (!this.match(name)) continue;
                matchFileEntries.put(name, r);
            }
        }
        catch (IOException ex) {
            try {
                throw new BuildException("problem reading " + src, ex);
            }
            catch (Throwable throwable) {
                FileUtils.close(ai);
                throw throwable;
            }
        }
        FileUtils.close(ai);
    }

    protected final void log(String msg) {
        if (this.project != null) {
            this.project.log(msg);
        } else {
            System.out.println(msg);
        }
    }

    public static interface ResourceBuilder {
        public Resource buildResource(Resource var1, String var2, ArchiveEntry var3);
    }
}

