/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.apache.http.impl.execchain;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import znaishaded.org.apache.commons.logging.Log;
import znaishaded.org.apache.commons.logging.LogFactory;
import znaishaded.org.apache.http.HttpException;
import znaishaded.org.apache.http.HttpHost;
import znaishaded.org.apache.http.HttpRequest;
import znaishaded.org.apache.http.ProtocolException;
import znaishaded.org.apache.http.annotation.Contract;
import znaishaded.org.apache.http.annotation.ThreadingBehavior;
import znaishaded.org.apache.http.auth.AuthScope;
import znaishaded.org.apache.http.auth.UsernamePasswordCredentials;
import znaishaded.org.apache.http.client.CredentialsProvider;
import znaishaded.org.apache.http.client.methods.CloseableHttpResponse;
import znaishaded.org.apache.http.client.methods.HttpExecutionAware;
import znaishaded.org.apache.http.client.methods.HttpRequestWrapper;
import znaishaded.org.apache.http.client.methods.HttpUriRequest;
import znaishaded.org.apache.http.client.protocol.HttpClientContext;
import znaishaded.org.apache.http.client.utils.URIUtils;
import znaishaded.org.apache.http.conn.routing.HttpRoute;
import znaishaded.org.apache.http.impl.client.BasicCredentialsProvider;
import znaishaded.org.apache.http.impl.execchain.ClientExecChain;
import znaishaded.org.apache.http.params.HttpParams;
import znaishaded.org.apache.http.protocol.HttpContext;
import znaishaded.org.apache.http.protocol.HttpProcessor;
import znaishaded.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ProtocolExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final HttpProcessor httpProcessor;

    public ProtocolExec(ClientExecChain requestExecutor, HttpProcessor httpProcessor) {
        Args.notNull(requestExecutor, "HTTP client request executor");
        Args.notNull(httpProcessor, "HTTP protocol processor");
        this.requestExecutor = requestExecutor;
        this.httpProcessor = httpProcessor;
    }

    void rewriteRequestURI(HttpRequestWrapper request, HttpRoute route2) throws ProtocolException {
        URI uri = request.getURI();
        if (uri != null) {
            try {
                request.setURI(URIUtils.rewriteURIForRoute(uri, route2));
            }
            catch (URISyntaxException ex) {
                throw new ProtocolException("Invalid URI: " + uri, ex);
            }
        }
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute route2, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        String userinfo;
        URI uri;
        block18: {
            Args.notNull(route2, "HTTP route");
            Args.notNull(request, "HTTP request");
            Args.notNull(context, "HTTP context");
            HttpRequest original = request.getOriginal();
            uri = null;
            if (original instanceof HttpUriRequest) {
                uri = ((HttpUriRequest)original).getURI();
            } else {
                String uriString = original.getRequestLine().getUri();
                try {
                    uri = URI.create(uriString);
                }
                catch (IllegalArgumentException ex) {
                    if (!this.log.isDebugEnabled()) break block18;
                    this.log.debug("Unable to parse '" + uriString + "' as a valid URI; " + "request URI and Host header may be inconsistent", ex);
                }
            }
        }
        request.setURI(uri);
        this.rewriteRequestURI(request, route2);
        HttpParams params = request.getParams();
        HttpHost virtualHost = (HttpHost)params.getParameter("http.virtual-host");
        if (virtualHost != null && virtualHost.getPort() == -1) {
            int port2 = route2.getTargetHost().getPort();
            if (port2 != -1) {
                virtualHost = new HttpHost(virtualHost.getHostName(), port2, virtualHost.getSchemeName());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Using virtual host" + virtualHost);
            }
        }
        HttpHost target = null;
        if (virtualHost != null) {
            target = virtualHost;
        } else if (uri != null && uri.isAbsolute() && uri.getHost() != null) {
            target = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        }
        if (target == null) {
            target = request.getTarget();
        }
        if (target == null) {
            target = route2.getTargetHost();
        }
        if (uri != null && (userinfo = uri.getUserInfo()) != null) {
            CredentialsProvider credsProvider = context.getCredentialsProvider();
            if (credsProvider == null) {
                credsProvider = new BasicCredentialsProvider();
                context.setCredentialsProvider(credsProvider);
            }
            credsProvider.setCredentials(new AuthScope(target), new UsernamePasswordCredentials(userinfo));
        }
        context.setAttribute("http.target_host", target);
        context.setAttribute("http.route", route2);
        context.setAttribute("http.request", request);
        this.httpProcessor.process(request, (HttpContext)context);
        CloseableHttpResponse response = this.requestExecutor.execute(route2, request, context, execAware);
        try {
            context.setAttribute("http.response", response);
            this.httpProcessor.process(response, (HttpContext)context);
            return response;
        }
        catch (RuntimeException ex) {
            response.close();
            throw ex;
        }
        catch (IOException ex) {
            response.close();
            throw ex;
        }
        catch (HttpException ex) {
            response.close();
            throw ex;
        }
    }
}

