/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.stathissideris.ascii2image.core;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import znaishaded.org.stathissideris.ascii2image.graphics.CustomShapeDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationParser {
    private static final boolean DEBUG = false;
    private static final String INLCUDE_TAG_NAME = "include";
    private static final String SHAPE_TAG_NAME = "shape";
    private static final String SHAPE_GROUP_TAG_NAME = "shapes";
    private String currentDir = "";
    private File configFile;
    private HashMap<String, CustomShapeDefinition> shapeDefinitions = new HashMap();

    public Collection<CustomShapeDefinition> getShapeDefinitions() {
        return this.shapeDefinitions.values();
    }

    public HashMap<String, CustomShapeDefinition> getShapeDefinitionsHash() {
        return this.shapeDefinitions;
    }

    public void parseFile(File file) throws ParserConfigurationException, SAXException, IOException {
        this.configFile = file;
        XMLHandler xMLHandler = new XMLHandler();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(file, (DefaultHandler)xMLHandler);
    }

    private String createFilename(String string, String string2) {
        if (string == null || string.trim().equals("")) {
            return string2;
        }
        if (string.endsWith(File.separator)) {
            return string + string2;
        }
        return string + File.separator + string2;
    }

    private boolean getBooleanFromAttributeValue(String string) {
        if ("no".equals(string = string.toLowerCase())) {
            return false;
        }
        if ("false".equals(string)) {
            return false;
        }
        if ("yes".equals(string)) {
            return true;
        }
        if ("true".equals(string)) {
            return true;
        }
        throw new IllegalArgumentException("value " + string + " cannot be interpreted as a boolean");
    }

    public static void main(String[] stringArray) throws ParserConfigurationException, SAXException, IOException {
        ConfigurationParser configurationParser = new ConfigurationParser();
        configurationParser.parseFile(new File("config.xml"));
        configurationParser.getShapeDefinitions();
    }

    private class XMLHandler
    extends DefaultHandler {
        private XMLHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            Serializable serializable;
            Object object;
            if (string3.equals(ConfigurationParser.SHAPE_GROUP_TAG_NAME)) {
                if (attributes.getLength() == 1) {
                    ConfigurationParser.this.currentDir = attributes.getValue(0).trim();
                    if (ConfigurationParser.this.currentDir.equals("")) {
                        ConfigurationParser.this.currentDir = ConfigurationParser.this.configFile.getParentFile().getAbsolutePath();
                    }
                } else {
                    ConfigurationParser.this.currentDir = ConfigurationParser.this.configFile.getParentFile().getAbsolutePath();
                }
            }
            if (string3.equals(ConfigurationParser.SHAPE_TAG_NAME)) {
                object = new CustomShapeDefinition();
                int n = attributes.getLength();
                for (int i = 0; i < n; ++i) {
                    String string4 = attributes.getQName(i);
                    String string5 = attributes.getValue(i);
                    if (string4.equals("tag")) {
                        ((CustomShapeDefinition)object).setTag(string5);
                        continue;
                    }
                    if (string4.equals("stretch")) {
                        ((CustomShapeDefinition)object).setStretches(ConfigurationParser.this.getBooleanFromAttributeValue(string5));
                        continue;
                    }
                    if (string4.equals("border")) {
                        ((CustomShapeDefinition)object).setHasBorder(ConfigurationParser.this.getBooleanFromAttributeValue(string5));
                        continue;
                    }
                    if (string4.equals("shadow")) {
                        ((CustomShapeDefinition)object).setDropsShadow(ConfigurationParser.this.getBooleanFromAttributeValue(string5));
                        continue;
                    }
                    if (string4.equals("comment")) {
                        ((CustomShapeDefinition)object).setComment(string5);
                        continue;
                    }
                    if (!string4.equals("filename")) continue;
                    File file = new File(string5);
                    if (file.isAbsolute()) {
                        ((CustomShapeDefinition)object).setFilename(string5);
                        continue;
                    }
                    ((CustomShapeDefinition)object).setFilename(ConfigurationParser.this.createFilename(ConfigurationParser.this.currentDir, string5));
                }
                if (ConfigurationParser.this.shapeDefinitions.containsKey(((CustomShapeDefinition)object).getTag())) {
                    CustomShapeDefinition customShapeDefinition = (CustomShapeDefinition)ConfigurationParser.this.shapeDefinitions.get(((CustomShapeDefinition)object).getTag());
                    System.err.println("*** Warning: shape \"" + customShapeDefinition.getTag() + "\" (file: " + customShapeDefinition.getFilename() + ") has been redefined as file: " + ((CustomShapeDefinition)object).getFilename());
                }
                if ((serializable = new File(((CustomShapeDefinition)object).getFilename())).exists()) {
                    ConfigurationParser.this.shapeDefinitions.put(((CustomShapeDefinition)object).getTag(), object);
                } else {
                    System.err.println("File " + serializable + " does not exist, skipping tag " + ((CustomShapeDefinition)object).getTag());
                }
            }
            if (string3.equals(ConfigurationParser.INLCUDE_TAG_NAME) && attributes.getLength() == 1) {
                object = new File(attributes.getValue(0).trim());
                if (!((File)object).isAbsolute()) {
                    object = new File(ConfigurationParser.this.createFilename(ConfigurationParser.this.configFile.getParentFile().getAbsolutePath(), ((File)object).getPath()));
                }
                if (!((File)object).exists()) {
                    System.err.println("Included file " + object + " does not exist, skipping");
                    return;
                }
                ConfigurationParser configurationParser = new ConfigurationParser();
                try {
                    configurationParser.parseFile((File)object);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    parserConfigurationException.printStackTrace();
                }
                catch (SAXException sAXException) {
                    sAXException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                serializable = configurationParser.getShapeDefinitionsHash();
                ConfigurationParser.this.shapeDefinitions.putAll(serializable);
            }
        }
    }
}

