/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.cli;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsOpts;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;
import org.testingisdocumenting.znai.utils.NumberUtils;

public class CliOutputIncludePlugin
implements IncludePlugin {
    private Path filePath;
    private List<String> lines;
    private ResourcesResolver resourcesResolver;
    private Path highlightFile;

    @Override
    public String id() {
        return "cli-output";
    }

    @Override
    public IncludePlugin create() {
        return new CliOutputIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.resourcesResolver = componentsRegistry.resourceResolver();
        this.filePath = this.resourcesResolver.fullPath(pluginParams.getFreeParam());
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(pluginParams.getOpts().toMap());
        this.lines = CliOutputIncludePlugin.readLines(componentsRegistry, this.filePath);
        props.put("lines", this.lines);
        props.put("highlight", this.findHighlightIndexes(pluginParams.getOpts()));
        return PluginResult.docElement("CliOutput", props);
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        Stream highlightFileStream = this.highlightFile != null ? Stream.of(AuxiliaryFile.builtTime(this.highlightFile)) : Stream.empty();
        return Stream.concat(Stream.of(AuxiliaryFile.builtTime(this.filePath)), highlightFileStream);
    }

    private static List<String> readLines(ComponentsRegistry componentsRegistry, Path filePath) {
        return Arrays.asList(componentsRegistry.resourceResolver().textContent(filePath).split("\n"));
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.STANDARD.text(String.join((CharSequence)" ", this.lines));
    }

    private List<Object> findHighlightIndexes(PluginParamsOpts opts) {
        List list = opts.has("highlightFile") ? this.readListFromFile(opts.getString("highlightFile")) : opts.getList("highlight");
        return list.stream().flatMap(this::findIndexes).collect(Collectors.toList());
    }

    private List<Object> readListFromFile(String file) {
        this.highlightFile = this.resourcesResolver.fullPath(file);
        return Arrays.stream(this.resourcesResolver.textContent(this.highlightFile).split("\n")).collect(Collectors.toList());
    }

    private Stream<Object> findIndexes(Object numberOrText) {
        if (NumberUtils.isInteger(numberOrText.toString())) {
            return Stream.of(numberOrText);
        }
        List foundIndexes = IntStream.range(0, this.lines.size()).filter(idx -> this.lines.get(idx).contains(numberOrText.toString())).boxed().collect(Collectors.toList());
        if (foundIndexes.isEmpty()) {
            throw new RuntimeException("can't find line: " + numberOrText);
        }
        return foundIndexes.stream();
    }
}

