/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.xml;

import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.extensions.xml.XmlToMapRepresentationConverter;
import org.testingisdocumenting.znai.parser.ParserHandler;

public class XmlIncludePlugin
implements IncludePlugin {
    private String fileName;

    @Override
    public String id() {
        return "xml";
    }

    @Override
    public IncludePlugin create() {
        return new XmlIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.fileName = pluginParams.getFreeParam();
        String xml = componentsRegistry.resourceResolver().textContent(this.fileName);
        Map<String, Object> props = pluginParams.getOpts().toMap();
        props.put("xmlAsJson", XmlToMapRepresentationConverter.convert(xml));
        props.put("paths", pluginParams.getOpts().getList("paths"));
        return PluginResult.docElement("Xml", props);
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(AuxiliaryFile.builtTime(componentsRegistry.resourceResolver().fullPath(this.fileName)));
    }
}

