/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.java.extensions;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.features.PluginFeatureList;
import org.testingisdocumenting.znai.extensions.file.CodeReferencesFeature;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.java.extensions.JavaIncludeResult;
import org.testingisdocumenting.znai.java.parser.JavaCode;
import org.testingisdocumenting.znai.java.parser.html.HtmlToDocElementConverter;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.parser.docelement.DocElement;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public abstract class JavaIncludePluginBase
implements IncludePlugin {
    protected String path;
    protected Path fullPath;
    protected ComponentsRegistry componentsRegistry;
    protected Path markupPath;
    protected PluginParams pluginParams;
    protected String entry;
    protected List<String> entries;
    private JavaIncludeResult javaIncludeResult;
    protected PluginFeatureList features;
    protected CodeReferencesFeature codeReferencesFeature;

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.codeReferencesFeature = new CodeReferencesFeature(componentsRegistry, markupPath, pluginParams);
        this.features = new PluginFeatureList(this.codeReferencesFeature);
        this.componentsRegistry = componentsRegistry;
        this.markupPath = markupPath;
        this.pluginParams = pluginParams;
        this.path = pluginParams.getFreeParam();
        this.fullPath = componentsRegistry.resourceResolver().fullPath(this.path);
        this.entry = (String)pluginParams.getOpts().get("entry");
        this.entries = pluginParams.getOpts().getList("entries");
        if (this.entry != null && !this.entries.isEmpty()) {
            throw new IllegalArgumentException("specify either entry or entries");
        }
        JavaCode javaCode = new JavaCode(componentsRegistry.resourceResolver().textContent(this.path));
        this.javaIncludeResult = this.process(javaCode);
        return PluginResult.docElements(this.javaIncludeResult.getDocElements().stream());
    }

    public abstract JavaIncludeResult process(JavaCode var1);

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return this.features.combineAuxiliaryFilesWith(Stream.of(AuxiliaryFile.builtTime(this.fullPath)));
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.HIGH.text(this.javaIncludeResult.getText());
    }

    protected List<Map<String, Object>> javaDocTextToDocElements(String html) {
        return HtmlToDocElementConverter.convert(this.componentsRegistry, this.markupPath, html, this.codeReferencesFeature.getReferences()).stream().map(DocElement::toMap).collect(Collectors.toList());
    }
}

