/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.server.preview;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.AuxiliaryFileListener;
import org.testingisdocumenting.znai.server.preview.FileChangeHandler;
import org.testingisdocumenting.znai.website.WebSite;

public class FileWatcher
implements AuxiliaryFileListener {
    private final WebSite.Configuration siteCfg;
    private final FileChangeHandler fileChangeHandler;
    private final WatchService watchService;
    private final Map<WatchKey, Path> pathByKey;

    public FileWatcher(WebSite.Configuration siteCfg, Stream<Path> auxiliaryFiles, FileChangeHandler fileChangeHandler) {
        this.siteCfg = siteCfg;
        this.fileChangeHandler = fileChangeHandler;
        this.watchService = this.createWatchService();
        this.pathByKey = new HashMap<WatchKey, Path>();
        Path absoluteRoot = siteCfg.getDocRootPath().toAbsolutePath();
        this.register(absoluteRoot);
        this.registerDirs(absoluteRoot);
        auxiliaryFiles.forEach(this::register);
    }

    public void start() {
        try {
            this.startWatchLoop();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void startWatchLoop() throws InterruptedException {
        while (true) {
            try {
                while (true) {
                    this.watchCycle();
                }
            }
            catch (RuntimeException e) {
                ConsoleOutputs.err(e.getClass() + ":" + e.getMessage());
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watchCycle() throws InterruptedException {
        WatchKey key = this.watchService.take();
        try {
            Path path2 = this.pathByKey.get(key);
            if (path2 == null) {
                ConsoleOutputs.err("bad watch key: ", key);
                return;
            }
            key.pollEvents().forEach(e -> this.handleEvent(path2, (WatchEvent<?>)e));
        }
        finally {
            boolean isValid = key.reset();
            if (!isValid) {
                this.pathByKey.remove(key);
            }
        }
    }

    private void handleEvent(Path parentPath, WatchEvent<?> watchEvent) {
        WatchEvent.Kind<?> kind = watchEvent.kind();
        if (kind == StandardWatchEventKinds.OVERFLOW) {
            return;
        }
        Path relativePath = (Path)watchEvent.context();
        Path path2 = parentPath.resolve(relativePath);
        ConsoleOutputs.out("watch event: ", kind, " context: ", path2);
        if (kind == StandardWatchEventKinds.ENTRY_CREATE || kind == StandardWatchEventKinds.ENTRY_MODIFY) {
            this.handleModify(path2);
        }
    }

    private void handleModify(Path path2) {
        String fileName = path2.getFileName().toString();
        if (Files.isDirectory(path2, new LinkOption[0])) {
            this.register(path2);
        } else if (fileName.equals("toc")) {
            this.fileChangeHandler.onTocChange(path2);
        } else if (fileName.equals("meta.json")) {
            this.fileChangeHandler.onDocMetaChange(path2);
        } else if (path2.equals(this.siteCfg.getGlobalReferencesPath())) {
            this.fileChangeHandler.onGlobalDocReferencesChange(path2);
        } else {
            this.fileChangeHandler.onChange(path2);
        }
    }

    private void register(Path path2) {
        try {
            if (!Files.exists(path2, new LinkOption[0])) {
                return;
            }
            if (!Files.isDirectory(path2, new LinkOption[0])) {
                path2 = path2.getParent();
            }
            if (path2.endsWith(".vertx")) {
                return;
            }
            if (this.pathByKey.containsValue(path2)) {
                return;
            }
            WatchKey key = path2.register(this.watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY}, SensitivityWatchEventModifier.HIGH);
            this.pathByKey.put(key, path2);
            ConsoleOutputs.out("watching: ", path2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void registerDirs(Path rootPath) {
        try {
            Stream<Path> pathStream = Files.list(rootPath);
            pathStream.filter(p -> Files.isDirectory(p, new LinkOption[0])).forEach(this::register);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private WatchService createWatchService() {
        WatchService watchService;
        try {
            watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return watchService;
    }

    @Override
    public void onAuxiliaryFile(AuxiliaryFile auxiliaryFile) {
        this.register(auxiliaryFile.getPath());
    }
}

