/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.server.sockets;

import java.util.Set;
import org.testingisdocumenting.znai.server.sockets.WebSocketHandler;
import org.testingisdocumenting.znai.utils.ServiceLoaderUtils;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.io.vertx.core.http.ServerWebSocket;

public class WebSocketHandlers {
    private static final Set<WebSocketHandler> handlers = ServiceLoaderUtils.load(WebSocketHandler.class);
    public static final Handler<ServerWebSocket> handler = WebSocketHandlers::handle;

    public static void add(WebSocketHandler provider) {
        handlers.add(provider);
    }

    public static void remove(WebSocketHandler provider) {
        handlers.remove(provider);
    }

    public static void init(Vertx vertx) {
        handlers.forEach(h -> h.init(vertx));
    }

    private static void handle(ServerWebSocket ws) {
        WebSocketHandler socketHandler = handlers.stream().filter(h -> h.handles(ws)).findFirst().orElseThrow(() -> new RuntimeException("no socket handler registered for " + ws.uri()));
        socketHandler.handle(ws);
    }
}

