/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.structure.TocItem;

public class TableOfContents {
    private List<TocItem> tocItems = new ArrayList<TocItem>();

    public TocItem addTocItem(String dirName, String fileNameWithoutExtension) {
        TocItem tocItem = new TocItem(dirName, fileNameWithoutExtension);
        this.tocItems.add(tocItem);
        return tocItem;
    }

    public TocItem addTocItem(String dirName, String fileNameWithoutExtension, String sectionTitle) {
        TocItem tocItem = new TocItem(dirName, fileNameWithoutExtension, sectionTitle);
        this.tocItems.add(tocItem);
        return tocItem;
    }

    public void addIndex() {
        this.tocItems.add(0, TocItem.createIndex());
    }

    public void removeTocItem(String dirName, String fileNameWithoutExtension) {
        this.tocItems.removeIf(item2 -> item2.match(dirName, fileNameWithoutExtension));
    }

    public void replaceTocItem(String originalDirName, String originalFileNameWithoutExtension, String newDirName, String newFileNameWithoutExtension) {
        int idx = this.findTocItemIdx(originalDirName, originalFileNameWithoutExtension);
        if (idx == -1) {
            throw new IllegalArgumentException("can't find toc item: " + originalDirName + "/" + originalFileNameWithoutExtension);
        }
        this.tocItems.set(idx, new TocItem(newDirName, newFileNameWithoutExtension));
    }

    public List<TocItem> detectNewTocItems(TableOfContents newToc) {
        LinkedHashSet<TocItem> existingItems = new LinkedHashSet<TocItem>(this.tocItems);
        LinkedHashSet<TocItem> newItems = new LinkedHashSet<TocItem>(newToc.tocItems);
        newItems.removeAll(existingItems);
        return new ArrayList<TocItem>(newItems);
    }

    public List<TocItem> detectRemovedTocItems(TableOfContents newToc) {
        LinkedHashSet<TocItem> existingItems = new LinkedHashSet<TocItem>(this.tocItems);
        LinkedHashSet<TocItem> newItems = new LinkedHashSet<TocItem>(newToc.tocItems);
        existingItems.removeAll(newItems);
        return new ArrayList<TocItem>(existingItems);
    }

    public TocItem getIndex() {
        if (this.tocItems.isEmpty()) {
            return null;
        }
        TocItem first = this.tocItems.get(0);
        return first.isIndex() ? first : null;
    }

    public List<TocItem> getTocItems() {
        return Collections.unmodifiableList(this.tocItems);
    }

    public boolean contains(String dirName, String fileName, String pageSectionId) {
        TocItem tocItem = this.findTocItem(dirName, fileName);
        return tocItem != null && (pageSectionId.isEmpty() || tocItem.hasPageSection(pageSectionId));
    }

    public TocItem findTocItem(String dirName, String fileNameWithoutExtension) {
        int idx = this.findTocItemIdx(dirName, fileNameWithoutExtension);
        return idx == -1 ? null : this.tocItems.get(idx);
    }

    public List<Map<String, Object>> toListOfMaps() {
        Map bySectionTitle = this.tocItems.stream().collect(Collectors.groupingBy(TocItem::getSectionTitle, LinkedHashMap::new, Collectors.toList()));
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        bySectionTitle.forEach((sectionTitle, items) -> result.add(this.createSectionWithItems((String)sectionTitle, (List<TocItem>)items)));
        return result;
    }

    private int findTocItemIdx(String dirName, String fileNameWithoutExtension) {
        for (int idx = 0; idx < this.tocItems.size(); ++idx) {
            if (!this.tocItems.get(idx).match(dirName, fileNameWithoutExtension)) continue;
            return idx;
        }
        return -1;
    }

    private Map<String, Object> createSectionWithItems(String sectionTitle, List<TocItem> items) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (items.isEmpty()) {
            return result;
        }
        result.put("sectionTitle", sectionTitle);
        result.put("dirName", items.iterator().next().getDirName());
        result.put("items", items.stream().map(TocItem::toMap).collect(Collectors.toList()));
        return result;
    }

    public String toString() {
        return this.tocItems.stream().map(TocItem::toString).collect(Collectors.joining("\n"));
    }
}

