/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.netty.handler.codec.base64;

import java.util.List;
import znaishaded.io.netty.buffer.ByteBuf;
import znaishaded.io.netty.channel.ChannelHandler;
import znaishaded.io.netty.channel.ChannelHandlerContext;
import znaishaded.io.netty.handler.codec.MessageToMessageEncoder;
import znaishaded.io.netty.handler.codec.base64.Base64;
import znaishaded.io.netty.handler.codec.base64.Base64Dialect;

@ChannelHandler.Sharable
public class Base64Encoder
extends MessageToMessageEncoder<ByteBuf> {
    private final boolean breakLines;
    private final Base64Dialect dialect;

    public Base64Encoder() {
        this(true);
    }

    public Base64Encoder(boolean breakLines) {
        this(breakLines, Base64Dialect.STANDARD);
    }

    public Base64Encoder(boolean breakLines, Base64Dialect dialect) {
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        this.breakLines = breakLines;
        this.dialect = dialect;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        out.add(Base64.encode(msg, msg.readerIndex(), msg.readableBytes(), this.breakLines, this.dialect));
    }
}

