/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.netty.handler.codec.http.websocketx;

import znaishaded.io.netty.channel.Channel;
import znaishaded.io.netty.channel.ChannelFuture;
import znaishaded.io.netty.channel.ChannelPromise;
import znaishaded.io.netty.handler.codec.http.DefaultFullHttpResponse;
import znaishaded.io.netty.handler.codec.http.HttpHeaderNames;
import znaishaded.io.netty.handler.codec.http.HttpRequest;
import znaishaded.io.netty.handler.codec.http.HttpResponseStatus;
import znaishaded.io.netty.handler.codec.http.HttpUtil;
import znaishaded.io.netty.handler.codec.http.HttpVersion;
import znaishaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import znaishaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker00;
import znaishaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker07;
import znaishaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker08;
import znaishaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker13;
import znaishaded.io.netty.handler.codec.http.websocketx.WebSocketVersion;

public class WebSocketServerHandshakerFactory {
    private final String webSocketURL;
    private final String subprotocols;
    private final boolean allowExtensions;
    private final int maxFramePayloadLength;
    private final boolean allowMaskMismatch;

    public WebSocketServerHandshakerFactory(String webSocketURL, String subprotocols, boolean allowExtensions) {
        this(webSocketURL, subprotocols, allowExtensions, 65536);
    }

    public WebSocketServerHandshakerFactory(String webSocketURL, String subprotocols, boolean allowExtensions, int maxFramePayloadLength) {
        this(webSocketURL, subprotocols, allowExtensions, maxFramePayloadLength, false);
    }

    public WebSocketServerHandshakerFactory(String webSocketURL, String subprotocols, boolean allowExtensions, int maxFramePayloadLength, boolean allowMaskMismatch) {
        this.webSocketURL = webSocketURL;
        this.subprotocols = subprotocols;
        this.allowExtensions = allowExtensions;
        this.maxFramePayloadLength = maxFramePayloadLength;
        this.allowMaskMismatch = allowMaskMismatch;
    }

    public WebSocketServerHandshaker newHandshaker(HttpRequest req) {
        String version = req.headers().get(HttpHeaderNames.SEC_WEBSOCKET_VERSION);
        if (version != null) {
            if (version.equals(WebSocketVersion.V13.toHttpHeaderValue())) {
                return new WebSocketServerHandshaker13(this.webSocketURL, this.subprotocols, this.allowExtensions, this.maxFramePayloadLength, this.allowMaskMismatch);
            }
            if (version.equals(WebSocketVersion.V08.toHttpHeaderValue())) {
                return new WebSocketServerHandshaker08(this.webSocketURL, this.subprotocols, this.allowExtensions, this.maxFramePayloadLength, this.allowMaskMismatch);
            }
            if (version.equals(WebSocketVersion.V07.toHttpHeaderValue())) {
                return new WebSocketServerHandshaker07(this.webSocketURL, this.subprotocols, this.allowExtensions, this.maxFramePayloadLength, this.allowMaskMismatch);
            }
            return null;
        }
        return new WebSocketServerHandshaker00(this.webSocketURL, this.subprotocols, this.maxFramePayloadLength);
    }

    @Deprecated
    public static void sendUnsupportedWebSocketVersionResponse(Channel channel2) {
        WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(channel2);
    }

    public static ChannelFuture sendUnsupportedVersionResponse(Channel channel2) {
        return WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(channel2, channel2.newPromise());
    }

    public static ChannelFuture sendUnsupportedVersionResponse(Channel channel2, ChannelPromise promise) {
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UPGRADE_REQUIRED);
        res.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)WebSocketVersion.V13.toHttpHeaderValue());
        HttpUtil.setContentLength(res, 0L);
        return channel2.writeAndFlush(res, promise);
    }
}

