/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.impl;

import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.io.netty.resolver.AddressResolverGroup;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.io.vertx.core.dns.AddressResolverOptions;
import znaishaded.io.vertx.core.impl.ContextInternal;
import znaishaded.io.vertx.core.impl.launcher.commands.ExecUtils;
import znaishaded.io.vertx.core.spi.resolver.ResolverProvider;

public class AddressResolver {
    private static final Pattern NDOTS_OPTIONS_PATTERN;
    private static final Pattern ROTATE_OPTIONS_PATTERN;
    public static final int DEFAULT_NDOTS_RESOLV_OPTION;
    public static final boolean DEFAULT_ROTATE_RESOLV_OPTION;
    private final Vertx vertx;
    private final AddressResolverGroup<InetSocketAddress> resolverGroup;
    private final ResolverProvider provider;

    private static Pattern resolvOption(String regex) {
        return Pattern.compile("^[ \\t\\f]*options[^\n]+" + regex + "(?=$|\\s)", 8);
    }

    public AddressResolver(Vertx vertx, AddressResolverOptions options) {
        this.provider = ResolverProvider.factory(vertx, options);
        this.resolverGroup = this.provider.resolver(options);
        this.vertx = vertx;
    }

    public void resolveHostname(String hostname, Handler<AsyncResult<InetAddress>> resultHandler) {
        ContextInternal callback = (ContextInternal)this.vertx.getOrCreateContext();
        znaishaded.io.netty.resolver.AddressResolver<InetSocketAddress> resolver = this.resolverGroup.getResolver(callback.nettyEventLoop());
        znaishaded.io.netty.util.concurrent.Future<InetSocketAddress> fut = resolver.resolve(InetSocketAddress.createUnresolved(hostname, 0));
        fut.addListener(a -> callback.runOnContext(v -> {
            if (a.isSuccess()) {
                InetSocketAddress address = (InetSocketAddress)fut.getNow();
                resultHandler.handle(Future.succeededFuture(address.getAddress()));
            } else {
                resultHandler.handle(Future.failedFuture(a.cause()));
            }
        }));
    }

    AddressResolverGroup<InetSocketAddress> nettyAddressResolverGroup() {
        return this.resolverGroup;
    }

    public void close(Handler<Void> doneHandler) {
        this.provider.close(doneHandler);
    }

    public static int parseNdotsOptionFromResolvConf(String s) {
        int ndots = -1;
        Matcher matcher = NDOTS_OPTIONS_PATTERN.matcher(s);
        while (matcher.find()) {
            ndots = Integer.parseInt(matcher.group(1));
        }
        return ndots;
    }

    public static boolean parseRotateOptionFromResolvConf(String s) {
        Matcher matcher = ROTATE_OPTIONS_PATTERN.matcher(s);
        return matcher.find();
    }

    static {
        File f;
        NDOTS_OPTIONS_PATTERN = AddressResolver.resolvOption("ndots:[ \\t\\f]*(\\d)+");
        ROTATE_OPTIONS_PATTERN = AddressResolver.resolvOption("rotate");
        int ndots = 1;
        boolean rotate = false;
        if (ExecUtils.isLinux() && (f = new File("/etc/resolv.conf")).exists() && f.isFile()) {
            try {
                String conf = new String(Files.readAllBytes(f.toPath()));
                int ndotsOption = AddressResolver.parseNdotsOptionFromResolvConf(conf);
                if (ndotsOption != -1) {
                    ndots = ndotsOption;
                }
                rotate = AddressResolver.parseRotateOptionFromResolvConf(conf);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        DEFAULT_NDOTS_RESOLV_OPTION = ndots;
        DEFAULT_ROTATE_RESOLV_OPTION = rotate;
    }
}

