/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.net.impl;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import znaishaded.io.netty.bootstrap.Bootstrap;
import znaishaded.io.netty.channel.Channel;
import znaishaded.io.netty.channel.ChannelFuture;
import znaishaded.io.netty.channel.ChannelHandler;
import znaishaded.io.netty.channel.ChannelHandlerContext;
import znaishaded.io.netty.channel.ChannelInboundHandlerAdapter;
import znaishaded.io.netty.channel.ChannelInitializer;
import znaishaded.io.netty.channel.ChannelPipeline;
import znaishaded.io.netty.handler.proxy.HttpProxyHandler;
import znaishaded.io.netty.handler.proxy.ProxyConnectionEvent;
import znaishaded.io.netty.handler.proxy.ProxyHandler;
import znaishaded.io.netty.handler.proxy.Socks4ProxyHandler;
import znaishaded.io.netty.handler.proxy.Socks5ProxyHandler;
import znaishaded.io.netty.resolver.NoopAddressResolverGroup;
import znaishaded.io.netty.util.concurrent.GenericFutureListener;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.impl.VertxInternal;
import znaishaded.io.vertx.core.net.ProxyOptions;
import znaishaded.io.vertx.core.net.ProxyType;
import znaishaded.io.vertx.core.net.SocketAddress;
import znaishaded.io.vertx.core.net.impl.ChannelProvider;

public class ProxyChannelProvider
extends ChannelProvider {
    public static final ChannelProvider INSTANCE = new ProxyChannelProvider();

    private ProxyChannelProvider() {
    }

    @Override
    public void connect(VertxInternal vertx, Bootstrap bootstrap, ProxyOptions options, SocketAddress remoteAddress, final Handler<Channel> channelInitializer, final Handler<AsyncResult<Channel>> channelHandler) {
        String proxyHost = options.getHost();
        int proxyPort = options.getPort();
        String proxyUsername = options.getUsername();
        String proxyPassword = options.getPassword();
        ProxyType proxyType = options.getType();
        vertx.resolveAddress(proxyHost, dnsRes -> {
            if (dnsRes.succeeded()) {
                ProxyHandler proxy;
                InetAddress address = (InetAddress)dnsRes.result();
                InetSocketAddress proxyAddr = new InetSocketAddress(address, proxyPort);
                switch (proxyType) {
                    default: {
                        proxy = proxyUsername != null && proxyPassword != null ? new HttpProxyHandler(proxyAddr, proxyUsername, proxyPassword) : new HttpProxyHandler(proxyAddr);
                        break;
                    }
                    case SOCKS5: {
                        proxy = proxyUsername != null && proxyPassword != null ? new Socks5ProxyHandler(proxyAddr, proxyUsername, proxyPassword) : new Socks5ProxyHandler(proxyAddr);
                        break;
                    }
                    case SOCKS4: {
                        proxy = proxyUsername != null ? new Socks4ProxyHandler(proxyAddr, proxyUsername) : new Socks4ProxyHandler(proxyAddr);
                    }
                }
                bootstrap.resolver(NoopAddressResolverGroup.INSTANCE);
                java.net.SocketAddress targetAddress = vertx.transport().convert(remoteAddress, false);
                bootstrap.handler(new ChannelInitializer<Channel>(){

                    @Override
                    protected void initChannel(final Channel ch) throws Exception {
                        final ChannelPipeline pipeline = ch.pipeline();
                        pipeline.addFirst("proxy", (ChannelHandler)proxy);
                        pipeline.addLast(new ChannelInboundHandlerAdapter(){

                            @Override
                            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                                if (evt instanceof ProxyConnectionEvent) {
                                    pipeline.remove(proxy);
                                    pipeline.remove(this);
                                    channelInitializer.handle(ch);
                                    channelHandler.handle(Future.succeededFuture(ch));
                                }
                                ctx.fireUserEventTriggered(evt);
                            }

                            @Override
                            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                                channelHandler.handle(Future.failedFuture(cause));
                            }
                        });
                    }
                });
                ChannelFuture future = bootstrap.connect(targetAddress);
                future.addListener((GenericFutureListener<? extends znaishaded.io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<znaishaded.io.netty.util.concurrent.Future>)res -> {
                    if (!res.isSuccess()) {
                        channelHandler.handle(Future.failedFuture(res.cause()));
                    }
                }));
            } else {
                channelHandler.handle(Future.failedFuture(dnsRes.cause()));
            }
        });
    }
}

