/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.sstore.impl;

import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.io.vertx.core.shareddata.AsyncMap;
import znaishaded.io.vertx.ext.auth.PRNG;
import znaishaded.io.vertx.ext.web.Session;
import znaishaded.io.vertx.ext.web.sstore.ClusteredSessionStore;
import znaishaded.io.vertx.ext.web.sstore.impl.SessionImpl;

public class ClusteredSessionStoreImpl
implements ClusteredSessionStore {
    private final Vertx vertx;
    private final PRNG random;
    private final String sessionMapName;
    private final long retryTimeout;
    private volatile AsyncMap<String, Session> sessionMap;

    public ClusteredSessionStoreImpl(Vertx vertx, String sessionMapName, long retryTimeout) {
        this.vertx = vertx;
        this.sessionMapName = sessionMapName;
        this.retryTimeout = retryTimeout;
        this.random = new PRNG(vertx);
    }

    @Override
    public long retryTimeout() {
        return this.retryTimeout;
    }

    @Override
    public Session createSession(long timeout) {
        return new SessionImpl(this.random, timeout, 16);
    }

    @Override
    public Session createSession(long timeout, int length) {
        return new SessionImpl(this.random, timeout, length);
    }

    @Override
    public void get(String id, Handler<AsyncResult<Session>> resultHandler) {
        this.getMap(res -> {
            if (res.succeeded()) {
                ((AsyncMap)res.result()).get(id, (AsyncResult<V> res2) -> {
                    if (res2.succeeded()) {
                        SessionImpl session = (SessionImpl)res2.result();
                        if (session != null) {
                            session.setPRNG(this.random);
                        }
                        resultHandler.handle(Future.succeededFuture(res2.result()));
                    } else {
                        resultHandler.handle(Future.failedFuture(res2.cause()));
                    }
                });
            } else {
                resultHandler.handle(Future.failedFuture(res.cause()));
            }
        });
    }

    @Override
    public void delete(String id, Handler<AsyncResult<Void>> resultHandler) {
        this.getMap(res -> {
            if (res.succeeded()) {
                ((AsyncMap)res.result()).remove(id, res2 -> {
                    if (res2.succeeded()) {
                        resultHandler.handle(Future.succeededFuture());
                    } else {
                        resultHandler.handle(Future.failedFuture(res2.cause()));
                    }
                });
            } else {
                resultHandler.handle(Future.failedFuture(res.cause()));
            }
        });
    }

    @Override
    public void put(Session session, Handler<AsyncResult<Void>> resultHandler) {
        this.getMap(res -> {
            if (res.succeeded()) {
                ((AsyncMap)res.result()).get(session.id(), (AsyncResult<V> old) -> {
                    SessionImpl newSession = (SessionImpl)session;
                    SessionImpl oldSession = old.succeeded() ? (SessionImpl)old.result() : null;
                    if (oldSession != null && oldSession.version() != newSession.version()) {
                        resultHandler.handle(Future.failedFuture("Version mismatch"));
                        return;
                    }
                    newSession.incrementVersion();
                    ((AsyncMap)res.result()).put(session.id(), session, session.timeout(), res2 -> {
                        if (res2.succeeded()) {
                            resultHandler.handle(Future.succeededFuture());
                        } else {
                            resultHandler.handle(Future.failedFuture(res2.cause()));
                        }
                    });
                });
            } else {
                resultHandler.handle(Future.failedFuture(res.cause()));
            }
        });
    }

    @Override
    public void clear(Handler<AsyncResult<Void>> resultHandler) {
        this.getMap(res -> {
            if (res.succeeded()) {
                ((AsyncMap)res.result()).clear(res2 -> {
                    if (res2.succeeded()) {
                        resultHandler.handle(Future.succeededFuture());
                    } else {
                        resultHandler.handle(Future.failedFuture(res2.cause()));
                    }
                });
            } else {
                resultHandler.handle(Future.failedFuture(res.cause()));
            }
        });
    }

    @Override
    public void size(Handler<AsyncResult<Integer>> resultHandler) {
        this.getMap(res -> {
            if (res.succeeded()) {
                ((AsyncMap)res.result()).size(res2 -> {
                    if (res2.succeeded()) {
                        resultHandler.handle(Future.succeededFuture(res2.result()));
                    } else {
                        resultHandler.handle(Future.failedFuture(res2.cause()));
                    }
                });
            } else {
                resultHandler.handle(Future.failedFuture(res.cause()));
            }
        });
    }

    @Override
    public void close() {
        this.random.close();
    }

    private void getMap(Handler<AsyncResult<AsyncMap<String, Session>>> resultHandler) {
        if (this.sessionMap == null) {
            this.vertx.sharedData().getClusterWideMap(this.sessionMapName, res -> {
                if (res.succeeded()) {
                    this.sessionMap = (AsyncMap)res.result();
                    resultHandler.handle(Future.succeededFuture(res.result()));
                } else {
                    resultHandler.handle((AsyncResult<AsyncMap<String, Session>>)res);
                }
            });
        } else {
            resultHandler.handle(Future.succeededFuture(this.sessionMap));
        }
    }
}

