/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.Branch;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.Instruction;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionCollection;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.WithNote;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileDecorateWelding;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.WeldingPoint;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileWithNoteOpale;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NoteType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructionIf
extends WithNote
implements Instruction,
InstructionCollection {
    private final List<Branch> thens = new ArrayList<Branch>();
    private Branch elseBranch;
    private boolean endifCalled = false;
    private final ISkinParam skinParam;
    private final Instruction parent;
    private Branch current;
    private final LinkRendering topInlinkRendering;
    private LinkRendering afterEndwhile = LinkRendering.none();
    private final Swimlane swimlane;

    public InstructionIf(Swimlane swimlane, Instruction instruction, Display display, Display display2, LinkRendering linkRendering, HtmlColor htmlColor, ISkinParam iSkinParam) {
        this.parent = instruction;
        this.skinParam = iSkinParam;
        this.topInlinkRendering = linkRendering;
        if (linkRendering == null) {
            throw new IllegalArgumentException();
        }
        this.swimlane = swimlane;
        this.thens.add(new Branch(swimlane, display2, display, htmlColor, Display.NULL));
        this.current = this.thens.get(0);
    }

    @Override
    public void add(Instruction instruction) {
        this.current.add(instruction);
    }

    @Override
    public Ftile createFtile(FtileFactory ftileFactory) {
        for (Branch object2 : this.thens) {
            object2.updateFtile(ftileFactory);
        }
        if (this.elseBranch == null) {
            this.elseBranch = new Branch(this.swimlane, Display.NULL, Display.NULL, null, Display.NULL);
        }
        this.elseBranch.updateFtile(ftileFactory);
        Object object3 = ftileFactory.createIf(this.swimlane, this.thens, this.elseBranch, this.afterEndwhile, this.topInlinkRendering);
        if (this.getPositionedNotes().size() > 0) {
            object3 = FtileWithNoteOpale.create((Ftile)object3, this.getPositionedNotes(), this.skinParam, false);
        }
        ArrayList<WeldingPoint> arrayList = new ArrayList<WeldingPoint>();
        for (Branch branch : this.thens) {
            arrayList.addAll(branch.getWeldingPoints());
        }
        arrayList.addAll(this.elseBranch.getWeldingPoints());
        if (arrayList.size() > 0) {
            object3 = new FtileDecorateWelding((Ftile)object3, arrayList);
        }
        return object3;
    }

    public Instruction getParent() {
        return this.parent;
    }

    public boolean swithToElse2(Display display, LinkRendering linkRendering) {
        if (this.elseBranch != null) {
            return false;
        }
        this.current.setInlinkRendering(linkRendering);
        this.current = this.elseBranch = new Branch(this.swimlane, display, Display.NULL, null, Display.NULL);
        return true;
    }

    public boolean elseIf(Display display, Display display2, Display display3, LinkRendering linkRendering, HtmlColor htmlColor) {
        if (this.elseBranch != null) {
            return false;
        }
        this.current.setInlinkRendering(linkRendering);
        this.current = new Branch(this.swimlane, display3, display2, htmlColor, display);
        this.thens.add(this.current);
        return true;
    }

    public void endif(LinkRendering linkRendering) {
        this.endifCalled = true;
        if (this.elseBranch == null) {
            this.elseBranch = new Branch(this.swimlane, Display.NULL, Display.NULL, null, Display.NULL);
        }
        this.current.setInlinkRendering(linkRendering);
    }

    @Override
    public final boolean kill() {
        Iterator<Branch> iterator;
        if (this.endifCalled && (iterator = this.thens.iterator()).hasNext()) {
            Branch branch = iterator.next();
            if (!branch.getLast().kill()) {
                return false;
            }
            return this.elseBranch == null || this.elseBranch.getLast() == null || this.elseBranch.getLast().kill();
        }
        return this.current.kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.topInlinkRendering;
    }

    @Override
    public boolean addNote(Display display, NotePosition notePosition, NoteType noteType, Colors colors, Swimlane swimlane) {
        if (this.endifCalled || this.current.isEmpty()) {
            return super.addNote(display, notePosition, noteType, colors, swimlane);
        }
        return this.current.addNote(display, notePosition, noteType, colors, swimlane);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> hashSet = new HashSet<Swimlane>();
        if (this.swimlane != null) {
            hashSet.add(this.swimlane);
        }
        for (Branch branch : this.thens) {
            hashSet.addAll(branch.getSwimlanes());
        }
        if (this.elseBranch != null) {
            hashSet.addAll(this.elseBranch.getSwimlanes());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    @Override
    public Instruction getLast() {
        if (this.elseBranch == null) {
            return this.thens.get(this.thens.size() - 1).getLast();
        }
        return this.elseBranch.getLast();
    }

    public void afterEndwhile(LinkRendering linkRendering) {
        this.afterEndwhile = linkRendering;
    }
}

