/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.command;

import java.util.List;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines2;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOr;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.graphic.Rainbow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandArrowLong3
extends CommandMultilines2<ActivityDiagram3> {
    public CommandArrowLong3() {
        super(CommandArrowLong3.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    @Override
    public String getPatternEnd() {
        return "^(.*);$";
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexOr(new RegexLeaf("->"), new RegexLeaf("COLOR", "-\\[((?:#\\w+|dotted|dashed|plain|bold|hidden)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden)*(?:;(?:#\\w+|dotted|dashed|plain|bold|hidden)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden)*)*)\\]->")), new RegexLeaf("[%s]*"), new RegexLeaf("LABEL", "(.*)"), new RegexLeaf("$"));
    }

    @Override
    public CommandExecutionResult executeNow(ActivityDiagram3 activityDiagram3, BlocLines blocLines) {
        blocLines = blocLines.removeEmptyColumns();
        RegexResult regexResult = this.getStartingPattern().matcher(StringUtils.trin(blocLines.getFirst499()));
        String string = regexResult.get("COLOR", 0);
        if (string != null) {
            Rainbow rainbow = Rainbow.build(activityDiagram3.getSkinParam(), string, activityDiagram3.getSkinParam().colorArrowSeparationSpace());
            activityDiagram3.setColorNextArrow(rainbow);
        }
        blocLines = blocLines.removeStartingAndEnding2(regexResult.get("LABEL", 0));
        activityDiagram3.setLabelNextArrow(blocLines.toDisplay());
        return CommandExecutionResult.ok();
    }

    private <CS extends CharSequence> void removeStarting(List<CS> list, String string) {
        if (list.size() == 0) {
            return;
        }
        list.set(0, string);
    }

    private <CS extends CharSequence> void removeEnding(List<CS> list) {
        if (list.size() == 0) {
            return;
        }
        int n = list.size() - 1;
        CharSequence charSequence = (CharSequence)list.get(n);
        list.set(n, charSequence.subSequence(0, charSequence.length() - 1));
    }
}

