/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.WeldingPoint;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileAssemblySimple
extends AbstractTextBlock
implements Ftile {
    private final Ftile tile1;
    private final Ftile tile2;
    private FtileGeometry calculateDimension;

    public String toString() {
        return "FtileAssemblySimple " + this.tile1 + " && " + this.tile2;
    }

    public FtileAssemblySimple(Ftile ftile, Ftile ftile2) {
        this.tile1 = ftile;
        this.tile2 = ftile2;
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tile1.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.tile2.getSwimlaneOut();
    }

    @Override
    public UTranslate getTranslateFor(Ftile ftile, StringBounder stringBounder) {
        if (ftile == this.tile1) {
            return this.getTranslated1(stringBounder);
        }
        if (ftile == this.tile2) {
            return this.getTranslated2(stringBounder);
        }
        UTranslate uTranslate = this.tile1.getTranslateFor(ftile, stringBounder);
        if (uTranslate != null) {
            return uTranslate.compose(this.getTranslated1(stringBounder));
        }
        uTranslate = this.tile2.getTranslateFor(ftile, stringBounder);
        if (uTranslate != null) {
            return uTranslate.compose(this.getTranslated2(stringBounder));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic.apply(this.getTranslated1(stringBounder)).draw(this.tile1);
        uGraphic.apply(this.getTranslated2(stringBounder)).draw(this.tile2);
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.tile1.getInLinkRendering();
    }

    @Override
    public LinkRendering getOutLinkRendering() {
        return LinkRendering.none();
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        if (this.calculateDimension == null) {
            this.calculateDimension = this.tile1.calculateDimension(stringBounder).appendBottom(this.tile2.calculateDimension(stringBounder));
        }
        return this.calculateDimension;
    }

    private UTranslate getTranslated1(StringBounder stringBounder) {
        double d = this.calculateDimension(stringBounder).getLeft();
        return new UTranslate(d - this.tile1.calculateDimension(stringBounder).getLeft(), 0.0);
    }

    private UTranslate getTranslated2(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.tile1.calculateDimension(stringBounder);
        double d = this.calculateDimension(stringBounder).getLeft();
        return new UTranslate(d - this.tile2.calculateDimension(stringBounder).getLeft(), ((Dimension2D)ftileGeometry).getHeight());
    }

    @Override
    public Collection<Connection> getInnerConnections() {
        return Collections.emptyList();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> hashSet = new HashSet<Swimlane>();
        hashSet.addAll(this.tile1.getSwimlanes());
        hashSet.addAll(this.tile2.getSwimlanes());
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public ISkinParam skinParam() {
        return this.tile1.skinParam();
    }

    @Override
    public UStroke getThickness() {
        return this.tile1.getThickness();
    }

    @Override
    public List<WeldingPoint> getWeldingPoints() {
        ArrayList<WeldingPoint> arrayList = new ArrayList<WeldingPoint>(this.tile1.getWeldingPoints());
        arrayList.addAll(this.tile2.getWeldingPoints());
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Arrays.asList(this.tile1, this.tile2);
    }

    @Override
    public HorizontalAlignment arrowHorizontalAlignment() {
        return this.tile1.arrowHorizontalAlignment();
    }
}

