/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParallelFtilesBuilder {
    protected final double barHeight = 6.0;
    private final Rose rose = new Rose();
    private final ISkinParam skinParam;
    private final StringBounder stringBounder;
    private final List<Ftile> list;
    private final Ftile middle;
    private final FtileGeometry middleDimension;
    private final Swimlane swimlane;

    public ParallelFtilesBuilder(ISkinParam iSkinParam, StringBounder stringBounder, List<Ftile> list, Ftile ftile, Swimlane swimlane) {
        this.skinParam = iSkinParam;
        this.stringBounder = stringBounder;
        this.list = list;
        this.middle = ftile;
        this.middleDimension = ftile.calculateDimension(this.getStringBounder());
        this.swimlane = swimlane;
    }

    public final Ftile build() {
        Ftile ftile = this.doStep1();
        return this.doStep2(ftile);
    }

    protected abstract Ftile doStep1();

    protected abstract Ftile doStep2(Ftile var1);

    protected StringBounder getStringBounder() {
        return this.stringBounder;
    }

    protected Rose getRose() {
        return this.rose;
    }

    protected ISkinParam skinParam() {
        return this.skinParam;
    }

    protected final TextBlock getTextBlock(Display display) {
        if (Display.isNull(display)) {
            return null;
        }
        FontConfiguration fontConfiguration = new FontConfiguration(this.skinParam(), FontParam.ARROW, null);
        return display.create(fontConfiguration, HorizontalAlignment.LEFT, (ISkinSimple)this.skinParam(), CreoleMode.SIMPLE_LINE);
    }

    protected TextBlock getTextBlock(LinkRendering linkRendering) {
        Display display = linkRendering.getDisplay();
        return this.getTextBlock(display);
    }

    protected final List<Ftile> getList() {
        return Collections.unmodifiableList(this.list);
    }

    protected final Ftile getMiddle() {
        return this.middle;
    }

    protected final double getHeightOfMiddle() {
        return this.middleDimension.getHeight();
    }

    protected final Swimlane swimlane() {
        return this.swimlane;
    }
}

