/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.asciiart;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.asciiart.AbstractComponentText;
import znaishaded.net.sourceforge.plantuml.asciiart.UmlCharArea;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.ComponentType;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class ComponentTextDivider
extends AbstractComponentText {
    private final ComponentType type;
    private final Display stringsToDisplay;
    private final FileFormat fileFormat;

    public ComponentTextDivider(ComponentType componentType, Display display, FileFormat fileFormat) {
        this.type = componentType;
        this.stringsToDisplay = display;
        this.fileFormat = fileFormat;
    }

    public void drawU(UGraphic uGraphic, Area area, Context2D context2D) {
        Dimension2D dimension2D = area.getDimensionToUse();
        UmlCharArea umlCharArea = ((UGraphicTxt)uGraphic).getCharArea();
        int n = (int)dimension2D.getWidth();
        int n2 = StringUtils.getWidth(this.stringsToDisplay);
        int n3 = (n - n2 - 1) / 2;
        String string = " " + this.stringsToDisplay.get(0).toString();
        if (this.fileFormat == FileFormat.UTXT) {
            umlCharArea.drawHLine('\u2550', 2, 0, n, '\u2502', '\u256a');
            umlCharArea.drawStringLR(string, n3, 2);
            umlCharArea.drawHLine('\u2550', 1, n3 - 1, n3 + string.length() + 1, '\u2502', '\u2567');
            umlCharArea.drawHLine('\u2550', 3, n3 - 1, n3 + string.length() + 1, '\u2502', '\u2564');
            umlCharArea.drawStringTB("\u2554\u2563\u255a", n3 - 1, 1);
            umlCharArea.drawStringTB("\u2557\u2560\u255d", n3 + string.length(), 1);
        } else {
            umlCharArea.drawHLine('=', 2, 0, n);
            umlCharArea.drawStringLR(string, n3, 2);
            umlCharArea.drawHLine('=', 1, n3 - 1, n3 + string.length() + 1);
            umlCharArea.drawHLine('=', 3, n3 - 1, n3 + string.length() + 1);
        }
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return StringUtils.getHeight(this.stringsToDisplay) + 4;
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return StringUtils.getWidth(this.stringsToDisplay) + 2;
    }
}

