/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.bpm;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.SkinParam;
import znaishaded.net.sourceforge.plantuml.UmlDiagram;
import znaishaded.net.sourceforge.plantuml.UmlDiagramType;
import znaishaded.net.sourceforge.plantuml.bpm.BpmBranch;
import znaishaded.net.sourceforge.plantuml.bpm.BpmElement;
import znaishaded.net.sourceforge.plantuml.bpm.BpmElementType;
import znaishaded.net.sourceforge.plantuml.bpm.BpmEvent;
import znaishaded.net.sourceforge.plantuml.bpm.BpmEventAdd;
import znaishaded.net.sourceforge.plantuml.bpm.BpmEventGoto;
import znaishaded.net.sourceforge.plantuml.bpm.BpmEventResume;
import znaishaded.net.sourceforge.plantuml.bpm.Cell;
import znaishaded.net.sourceforge.plantuml.bpm.CleanerEmptyLine;
import znaishaded.net.sourceforge.plantuml.bpm.CleanerInterleavingLines;
import znaishaded.net.sourceforge.plantuml.bpm.CleanerMoveBlock;
import znaishaded.net.sourceforge.plantuml.bpm.Col;
import znaishaded.net.sourceforge.plantuml.bpm.Coord;
import znaishaded.net.sourceforge.plantuml.bpm.Grid;
import znaishaded.net.sourceforge.plantuml.bpm.GridArray;
import znaishaded.net.sourceforge.plantuml.bpm.Line;
import znaishaded.net.sourceforge.plantuml.bpm.Navigator;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.graphic.UDrawable;
import znaishaded.net.sourceforge.plantuml.ugraphic.ImageBuilder;

public class BpmDiagram
extends UmlDiagram {
    private final BpmElement start = new BpmElement(null, BpmElementType.START);
    private List<BpmEvent> events = new ArrayList<BpmEvent>();
    private Deque<BpmBranch> branches = new ArrayDeque<BpmBranch>();
    private Coord current;
    private Cell last;

    private void cleanGrid(Grid grid) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        do {
            bl3 = new CleanerEmptyLine().clean(grid);
            bl2 = new CleanerInterleavingLines().clean(grid);
            bl = new CleanerMoveBlock().clean(grid);
        } while (bl3 || bl2 || bl);
    }

    public DiagramDescription getDescription() {
        return new DiagramDescription("(Bpm Diagram)");
    }

    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.BPM;
    }

    protected ImageData exportDiagramInternal(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        ImageBuilder imageBuilder = new ImageBuilder(this.getSkinParam(), 1.0, fileFormatOption.isWithMetadata() ? this.getMetadata() : null, this.getWarningOrError(), 10.0, 10.0, this.getAnimation());
        imageBuilder.setUDrawable(this.getUDrawable());
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, this.seed(), outputStream);
    }

    private UDrawable getUDrawable() {
        Grid grid = this.createGrid();
        this.cleanGrid(grid);
        GridArray gridArray = grid.toArray(SkinParam.create(this.getUmlDiagramType()));
        System.err.println("gridArray=" + gridArray);
        return gridArray;
    }

    public CommandExecutionResult addEvent(BpmEvent bpmEvent) {
        this.events.add(bpmEvent);
        return CommandExecutionResult.ok();
    }

    private Grid createGrid() {
        Grid grid = new Grid();
        this.current = grid.getRoot();
        this.last = grid.getCell(this.current);
        grid.getCell(this.current).setData(this.start);
        for (BpmEvent bpmEvent : this.events) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            if (bpmEvent instanceof BpmEventAdd) {
                object4 = (BpmEventAdd)bpmEvent;
                this.addInGrid(grid, ((BpmEventAdd)object4).getElement());
                continue;
            }
            if (bpmEvent instanceof BpmEventResume) {
                object4 = ((BpmEventResume)bpmEvent).getId();
                this.current = grid.getById((String)object4);
                this.last = grid.getCell(this.current);
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                object3 = grid.linesOf(this.current);
                object2 = new Line();
                object3.insertAfter(object2);
                object = this.current.getCol();
                this.current = new Coord((Line)object2, (Col)object);
                continue;
            }
            if (bpmEvent instanceof BpmEventGoto) {
                object4 = (BpmEventGoto)bpmEvent;
                object3 = ((BpmEventGoto)object4).getId();
                this.current = grid.getById((String)object3);
                object2 = this.last;
                this.last = grid.getCell(this.current);
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                object = grid.linesOf(this.current);
                Line line = new Line();
                object.insertAfter(line);
                Col col = this.current.getCol();
                this.current = new Coord(line, col);
                ((Cell)object2).addConnectionTo2(this.last.getData());
                continue;
            }
            throw new IllegalStateException();
        }
        grid.addConnections();
        return grid;
    }

    private void addInGrid(Grid grid, BpmElement bpmElement) {
        Navigator<Col> navigator = grid.colsOf(this.current);
        Col col = new Col();
        navigator.insertAfter(col);
        this.current = new Coord(this.current.getLine(), col);
        grid.getCell(this.current).setData(bpmElement);
        this.last.addConnectionTo2(grid.getCell(this.current).getData());
        this.last = grid.getCell(this.current);
    }

    public CommandExecutionResult newBranch() {
        BpmBranch bpmBranch = new BpmBranch(this.events.size());
        this.branches.addLast(bpmBranch);
        return this.addEvent(new BpmEventAdd(bpmBranch.getEntryElement()));
    }

    public CommandExecutionResult elseBranch() {
        BpmBranch bpmBranch = this.branches.getLast();
        int n = bpmBranch.incAndGetCounter();
        if (n == 2) {
            this.addEvent(new BpmEventAdd(bpmBranch.getElseElement()));
            return this.addEvent(bpmBranch.getResumeEntryEvent());
        }
        this.addEvent(bpmBranch.getGoToEndEvent());
        return this.addEvent(bpmBranch.getResumeEntryEvent());
    }

    public CommandExecutionResult endBranch() {
        BpmBranch bpmBranch = this.branches.removeLast();
        return this.addEvent(bpmBranch.getGoToEndEvent());
    }
}

