/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.classdiagram;

import java.io.IOException;
import java.io.OutputStream;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.UmlDiagramType;
import znaishaded.net.sourceforge.plantuml.classdiagram.FullLayout;
import znaishaded.net.sourceforge.plantuml.classdiagram.RowLayout;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Code;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.EntityUtils;
import znaishaded.net.sourceforge.plantuml.cucadiagram.GroupType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IGroup;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LeafType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Link;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.USymbol;
import znaishaded.net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageClass;
import znaishaded.net.sourceforge.plantuml.ugraphic.ImageBuilder;

public class ClassDiagram
extends AbstractClassOrObjectDiagram {
    private String namespaceSeparator = ".";
    private boolean allowMixing;
    private int useLayoutExplicit = 0;

    public ILeaf getOrCreateLeaf(Code code, LeafType leafType, USymbol uSymbol) {
        if (this.namespaceSeparator != null) {
            code = code.withSeparator(this.namespaceSeparator);
        }
        if (leafType == null) {
            code = code.eventuallyRemoveStartingAndEndingDoubleQuote("\"([:");
            if (this.namespaceSeparator == null) {
                return this.getOrCreateLeafDefault(code, LeafType.CLASS, uSymbol);
            }
            if (super.leafExist(code = code.getFullyQualifiedCode(this.getCurrentGroup()))) {
                return this.getOrCreateLeafDefault(code, LeafType.CLASS, uSymbol);
            }
            return this.createEntityWithNamespace(code, Display.getWithNewlines(code.getShortName(this.getLeafs())), LeafType.CLASS, uSymbol);
        }
        if (this.namespaceSeparator == null) {
            return this.getOrCreateLeafDefault(code, LeafType.CLASS, uSymbol);
        }
        if (super.leafExist(code = code.getFullyQualifiedCode(this.getCurrentGroup()))) {
            return this.getOrCreateLeafDefault(code, leafType, uSymbol);
        }
        return this.createEntityWithNamespace(code, Display.getWithNewlines(code.getShortName(this.getLeafs())), leafType, uSymbol);
    }

    public IGroup getOrCreateNamespace(Code code, Display display, GroupType groupType, IGroup iGroup) {
        IGroup iGroup2;
        if (this.namespaceSeparator != null) {
            code = code.withSeparator(this.namespaceSeparator).getFullyQualifiedCode(this.getCurrentGroup());
        }
        this.currentGroup = iGroup2 = this.getOrCreateNamespaceInternal(code, display, groupType, iGroup);
        return iGroup2;
    }

    private IGroup getOrCreateNamespaceInternal(Code code, Display display, GroupType groupType, IGroup iGroup) {
        IGroup iGroup2 = this.entityFactory.getGroups().get(code);
        if (iGroup2 != null) {
            return iGroup2;
        }
        if (this.entityFactory.getLeafs().containsKey(code)) {
            iGroup2 = this.entityFactory.muteToGroup(code, code, groupType, iGroup);
            iGroup2.setDisplay(display);
        } else {
            iGroup2 = this.entityFactory.createGroup(code, display, code, groupType, iGroup, this.getHides(), this.getNamespaceSeparator());
        }
        this.entityFactory.addGroup(iGroup2);
        return iGroup2;
    }

    public ILeaf createLeaf(Code code, Display display, LeafType leafType, USymbol uSymbol) {
        if (this.namespaceSeparator != null) {
            code = code.withSeparator(this.namespaceSeparator);
        }
        if (leafType != LeafType.ABSTRACT_CLASS && leafType != LeafType.ANNOTATION && leafType != LeafType.CLASS && leafType != LeafType.INTERFACE && leafType != LeafType.ENUM && leafType != LeafType.LOLLIPOP && leafType != LeafType.NOTE) {
            return super.createLeaf(code, display, leafType, uSymbol);
        }
        if (this.namespaceSeparator == null) {
            return super.createLeaf(code, display, leafType, uSymbol);
        }
        if (super.leafExist(code = code.getFullyQualifiedCode(this.getCurrentGroup()))) {
            throw new IllegalArgumentException("Already known: " + code);
        }
        return this.createEntityWithNamespace(code, display, leafType, uSymbol);
    }

    private ILeaf createEntityWithNamespace(Code code, Display display, LeafType leafType, USymbol uSymbol) {
        IGroup iGroup = this.getCurrentGroup();
        String string = this.getNamespace(code);
        if (string != null && (EntityUtils.groupRoot(iGroup) || !iGroup.getCode().getFullName().equals(string))) {
            Code code2 = Code.of(string);
            iGroup = this.getOrCreateNamespaceInternal(code2, Display.getWithNewlines(string), GroupType.PACKAGE, this.getRootGroup());
        }
        return this.createLeafInternal(code, Display.isNull(display) ? Display.getWithNewlines(code.getShortName(this.getLeafs())).withCreoleMode(CreoleMode.SIMPLE_LINE) : display, leafType, iGroup, uSymbol);
    }

    private final String getNamespace(Code code) {
        String string = code.getFullName();
        do {
            int n;
            if ((n = string.lastIndexOf(this.namespaceSeparator)) == -1) {
                return null;
            }
            string = string.substring(0, n);
        } while (this.getLeafs().containsKey(Code.of(string, this.namespaceSeparator)));
        return string;
    }

    public final boolean leafExist(Code code) {
        if (this.namespaceSeparator == null) {
            return super.leafExist(code);
        }
        code = code.withSeparator(this.namespaceSeparator);
        return super.leafExist(code.getFullyQualifiedCode(this.getCurrentGroup()));
    }

    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.CLASS;
    }

    public void setNamespaceSeparator(String string) {
        this.namespaceSeparator = string;
    }

    public String getNamespaceSeparator() {
        return this.namespaceSeparator;
    }

    public void setAllowMixing(boolean bl) {
        this.allowMixing = bl;
    }

    public boolean isAllowMixing() {
        return this.allowMixing;
    }

    public void layoutNewLine() {
        ++this.useLayoutExplicit;
        this.incRawLayout();
    }

    protected final ImageData exportDiagramInternal(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        if (this.useLayoutExplicit != 0) {
            return this.exportLayoutExplicit(outputStream, n, fileFormatOption);
        }
        return super.exportDiagramInternal(outputStream, n, fileFormatOption);
    }

    protected final ImageData exportLayoutExplicit(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        FullLayout fullLayout = new FullLayout();
        for (int i = 0; i <= this.useLayoutExplicit; ++i) {
            RowLayout rowLayout = this.getRawLayout(i);
            fullLayout.addRowLayout(rowLayout);
        }
        ImageBuilder imageBuilder = new ImageBuilder(this.getSkinParam(), 1.0, null, null, 0.0, 10.0, null);
        imageBuilder.setUDrawable(fullLayout);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, this.seed(), outputStream);
    }

    private RowLayout getRawLayout(int n) {
        RowLayout rowLayout = new RowLayout();
        for (ILeaf iLeaf : this.getLeafs().values()) {
            if (iLeaf.getRawLayout() != n) continue;
            rowLayout.addLeaf(this.getEntityImageClass(iLeaf));
        }
        return rowLayout;
    }

    private TextBlock getEntityImageClass(ILeaf iLeaf) {
        return new EntityImageClass(null, iLeaf, this.getSkinParam(), this);
    }

    public String checkFinalError() {
        for (Link link : this.getLinks()) {
            int n = link.getLength();
            if (n != 1) continue;
            for (Link link2 : this.getLinks()) {
                if (!link2.sameConnections(link) || link2.getLength() == 1) continue;
                link2.setLength(1);
            }
        }
        this.applySingleStrategy();
        return super.checkFinalError();
    }
}

