/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole;

import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.creole.Command;
import znaishaded.net.sourceforge.plantuml.creole.StripeSimple;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;

public class CommandCreoleSizeChange
implements Command {
    private final Pattern2 pattern;

    public static Command create() {
        return new CommandCreoleSizeChange("^(?i)(\\<size[\\s:]+(\\d+)[%s]*\\>(.*?)\\</size\\>)");
    }

    public static Command createEol() {
        return new CommandCreoleSizeChange("^(?i)(\\<size[\\s:]+(\\d+)[%s]*\\>(.*)$)");
    }

    private CommandCreoleSizeChange(String string) {
        this.pattern = MyPattern.cmpile(string);
    }

    public int matchingSize(String string) {
        Matcher2 matcher2 = this.pattern.matcher(string);
        if (!matcher2.find()) {
            return 0;
        }
        return matcher2.group(2).length();
    }

    public String executeAndGetRemaining(String string, StripeSimple stripeSimple) {
        Matcher2 matcher2 = this.pattern.matcher(string);
        if (!matcher2.find()) {
            throw new IllegalStateException();
        }
        int n = Integer.parseInt(matcher2.group(2));
        FontConfiguration fontConfiguration = stripeSimple.getActualFontConfiguration();
        FontConfiguration fontConfiguration2 = fontConfiguration.changeSize(n);
        stripeSimple.setActualFontConfiguration(fontConfiguration2);
        stripeSimple.analyzeAndAdd(matcher2.group(3));
        stripeSimple.setActualFontConfiguration(fontConfiguration);
        return string.substring(matcher2.group(1).length());
    }
}

