/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole;

import znaishaded.net.sourceforge.plantuml.creole.Atom;
import znaishaded.net.sourceforge.plantuml.creole.AtomText;
import znaishaded.net.sourceforge.plantuml.creole.Bullet;
import znaishaded.net.sourceforge.plantuml.creole.CreoleContext;
import znaishaded.net.sourceforge.plantuml.creole.StripeStyleType;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;

public class StripeStyle {
    private final StripeStyleType type;
    private final int order;
    private final char style;

    public StripeStyle(StripeStyleType stripeStyleType, int n, char c) {
        this.type = stripeStyleType;
        this.order = n;
        this.style = c;
    }

    public final StripeStyleType getType() {
        return this.type;
    }

    public Atom getHeader(FontConfiguration fontConfiguration, CreoleContext creoleContext) {
        if (this.type == StripeStyleType.LIST_WITHOUT_NUMBER) {
            return new Bullet(fontConfiguration, this.order);
        }
        if (this.type == StripeStyleType.LIST_WITH_NUMBER) {
            int n = creoleContext.getLocalNumber(this.order);
            return AtomText.createListNumber(fontConfiguration, this.order, n);
        }
        return null;
    }

    public final int getOrder() {
        return this.order;
    }

    public char getStyle() {
        return this.style;
    }
}

