/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Election {
    private final Map<String, Member> all = new HashMap<String, Member>();

    Election() {
    }

    public void addCandidate(String string, Member member) {
        this.all.put(string, member);
    }

    private Member getCandidate(String string) {
        List<Member> list = this.getAllCandidateContains(string);
        if (list.size() == 1) {
            return list.get(0);
        }
        list = this.getAllCandidateContainsStrict(string);
        if (list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    private List<Member> getAllCandidateContains(String string) {
        ArrayList<Member> arrayList = new ArrayList<Member>();
        for (Map.Entry<String, Member> entry : this.all.entrySet()) {
            if (!entry.getKey().contains(string)) continue;
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }

    private List<Member> getAllCandidateContainsStrict(String string) {
        ArrayList<Member> arrayList = new ArrayList<Member>();
        for (Map.Entry<String, Member> entry : this.all.entrySet()) {
            String string2 = entry.getKey();
            if (!string2.matches(".*\\b" + string + "\\b.*")) continue;
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }

    public Map<Member, String> getAllElected(Collection<String> collection) {
        HashMap<Member, String> hashMap = new HashMap<Member, String>();
        for (String string : collection) {
            Member member = this.getCandidate(string);
            if (member == null) continue;
            hashMap.put(member, string);
        }
        return Collections.unmodifiableMap(hashMap);
    }
}

