/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cucadiagram;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IGroup;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;

public class GroupPrinter {
    private final PrintWriter pw;

    private GroupPrinter(PrintWriter printWriter) {
        this.pw = printWriter;
    }

    private void printGroup(IGroup iGroup) {
        this.pw.println("<table border=1 cellpadding=8 cellspacing=0>");
        this.pw.println("<tr>");
        this.pw.println("<td bgcolor=#DDDDDD>");
        this.pw.println(iGroup.getCode());
        this.pw.println("<tr>");
        this.pw.println("<td>");
        if (iGroup.getLeafsDirect().size() == 0) {
            this.pw.println("<i>No direct leaf</i>");
        } else {
            for (ILeaf iEntity : iGroup.getLeafsDirect()) {
                this.pw.println("<ul>");
                this.printLeaf(iEntity);
                this.pw.println("</ul>");
            }
        }
        this.pw.println("</td>");
        this.pw.println("</tr>");
        if (iGroup.getChildren().size() > 0) {
            this.pw.println("<tr>");
            this.pw.println("<td>");
            for (IGroup iGroup2 : iGroup.getChildren()) {
                this.pw.println("<br>");
                this.printGroup(iGroup2);
                this.pw.println("<br>");
            }
            this.pw.println("</td>");
            this.pw.println("</tr>");
        }
        this.pw.println("</table>");
    }

    private void printLeaf(ILeaf iLeaf) {
        this.pw.println("<li>" + iLeaf.getCode());
    }

    public static void print(File file, IGroup iGroup) {
        try {
            PrintWriter printWriter = new PrintWriter(file);
            printWriter.println("<html>");
            new GroupPrinter(printWriter).printGroup(iGroup);
            printWriter.println("</html>");
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

