/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.geom;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.geom.AbstractFigure;
import znaishaded.net.sourceforge.plantuml.geom.ClosedArea;
import znaishaded.net.sourceforge.plantuml.geom.LineSegmentInt;
import znaishaded.net.sourceforge.plantuml.geom.Point2DInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Kingdom
extends AbstractFigure {
    private Set<ClosedArea> buildClosedArea(ClosedArea closedArea) {
        if (closedArea.isClosed()) {
            throw new IllegalArgumentException();
        }
        HashSet<ClosedArea> hashSet = new HashSet<ClosedArea>();
        for (LineSegmentInt lineSegmentInt : this.getSegmentsWithExtremity(closedArea.getFreePoint(), closedArea.getSegments())) {
            ClosedArea closedArea2 = closedArea.append(lineSegmentInt);
            if (closedArea2 == null) continue;
            hashSet.add(closedArea2);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private void grow(Set<ClosedArea> set) {
        for (ClosedArea closedArea : new HashSet<ClosedArea>(set)) {
            if (closedArea.isClosed()) continue;
            set.addAll(this.buildClosedArea(closedArea));
        }
    }

    public Set<ClosedArea> getAllClosedArea() {
        int n;
        HashSet<ClosedArea> hashSet = new HashSet<ClosedArea>();
        for (LineSegmentInt object2 : this.getSegments()) {
            hashSet.add(new ClosedArea().append(object2));
        }
        do {
            n = hashSet.size();
            this.grow(hashSet);
        } while (hashSet.size() != n);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ClosedArea closedArea = (ClosedArea)iterator.next();
            if (closedArea.isClosed()) continue;
            iterator.remove();
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public boolean arePointsConnectable(Point2DInt point2DInt, Point2DInt point2DInt2) {
        for (ClosedArea closedArea : this.getAllClosedArea()) {
            if (closedArea.arePointsConnectable(point2DInt, point2DInt2)) continue;
            return false;
        }
        return true;
    }
}

