/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graph;

import znaishaded.net.sourceforge.plantuml.geom.LineSegmentInt;
import znaishaded.net.sourceforge.plantuml.graph.ALink;
import znaishaded.net.sourceforge.plantuml.graph.ANode;
import znaishaded.net.sourceforge.plantuml.graph.Board;
import znaishaded.net.sourceforge.plantuml.graph.CostComputer;

public class KenavoCostComputer
implements CostComputer {
    public double getCost(Board board) {
        double d = 0.0;
        for (ALink aLink : board.getLinks()) {
            for (ALink aLink2 : board.getLinks()) {
                d += this.getCost(board, aLink, aLink2);
            }
        }
        return d;
    }

    LineSegmentInt getLineSegment(Board board, ALink aLink) {
        ANode aNode = aLink.getNode1();
        ANode aNode2 = aLink.getNode2();
        return new LineSegmentInt(board.getCol(aNode), aNode.getRow(), board.getCol(aNode2), aNode2.getRow());
    }

    private double getCost(Board board, ALink aLink, ALink aLink2) {
        LineSegmentInt lineSegmentInt = this.getLineSegment(board, aLink);
        LineSegmentInt lineSegmentInt2 = this.getLineSegment(board, aLink2);
        double d = this.getLength(aLink, lineSegmentInt, board);
        double d2 = this.getLength(aLink2, lineSegmentInt2, board);
        return d * d2 * Math.exp(-lineSegmentInt.getDistance(lineSegmentInt2));
    }

    private double getLength(ALink aLink, LineSegmentInt lineSegmentInt, Board board) {
        double d = 1.0;
        if (aLink.getNode1().getRow() == aLink.getNode2().getRow() && board.getDirection(aLink) != board.getInitialDirection(aLink)) {
            d = 1.1;
        }
        return lineSegmentInt.getLength() * d;
    }
}

