/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class CircledCharacter
extends AbstractTextBlock
implements TextBlock {
    private final String c;
    private final UFont font;
    private final HtmlColor innerCircle;
    private final HtmlColor circle;
    private final HtmlColor fontColor;
    private final double radius;

    public CircledCharacter(char c, double d, UFont uFont, HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3) {
        this.c = "" + c;
        this.radius = d;
        this.font = uFont;
        this.innerCircle = htmlColor;
        this.circle = htmlColor2;
        this.fontColor = htmlColor3;
    }

    public void drawU(UGraphic uGraphic) {
        if (this.circle != null) {
            uGraphic = uGraphic.apply(new UChangeColor(this.circle));
        }
        uGraphic = uGraphic.apply(new UChangeBackColor(this.innerCircle));
        uGraphic.draw(new UEllipse(this.radius * 2.0, this.radius * 2.0));
        uGraphic = uGraphic.apply(new UChangeColor(this.fontColor));
        uGraphic = uGraphic.apply(new UTranslate(this.radius, this.radius));
        uGraphic.draw(new UCenteredCharacter(this.c.charAt(0), this.font));
    }

    public final double getPreferredWidth(StringBounder stringBounder) {
        return 2.0 * this.radius;
    }

    public final double getPreferredHeight(StringBounder stringBounder) {
        return 2.0 * this.radius;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(this.getPreferredWidth(stringBounder), this.getPreferredHeight(stringBounder));
    }
}

