/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.SkinParameter;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.SymbolContext;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.graphic.USymbol;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

class USymbolRect
extends USymbol {
    private final SkinParameter skinParameter;
    private final HorizontalAlignment stereotypeAlignement;

    public USymbolRect(SkinParameter skinParameter, HorizontalAlignment horizontalAlignment) {
        this.skinParameter = skinParameter;
        this.stereotypeAlignement = horizontalAlignment;
    }

    public USymbol withStereoAlignment(HorizontalAlignment horizontalAlignment) {
        return new USymbolRect(this.skinParameter, horizontalAlignment);
    }

    public SkinParameter getSkinParameter() {
        return this.skinParameter;
    }

    private void drawRect(UGraphic uGraphic, double d, double d2, boolean bl, double d3) {
        URectangle uRectangle = new URectangle(d, d2, d3, d3);
        if (bl) {
            uRectangle.setDeltaShadow(3.0);
        }
        uGraphic.draw(uRectangle);
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 10.0, 10.0, 10.0);
    }

    public TextBlock asSmall(TextBlock textBlock, final TextBlock textBlock2, final TextBlock textBlock3, final SymbolContext symbolContext) {
        return new AbstractTextBlock(){

            public void drawU(UGraphic uGraphic) {
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                uGraphic = UGraphicStencil.create(uGraphic, USymbolRect.this.getRectangleStencil(dimension2D), new UStroke());
                uGraphic = symbolContext.apply(uGraphic);
                USymbolRect.this.drawRect(uGraphic, dimension2D.getWidth(), dimension2D.getHeight(), symbolContext.isShadowing(), symbolContext.getRoundCorner());
                USymbol.Margin margin = USymbolRect.this.getMargin();
                TextBlock textBlock = TextBlockUtils.mergeTB(textBlock3, textBlock2, USymbolRect.this.stereotypeAlignement);
                textBlock.drawU(uGraphic.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimension2D = textBlock2.calculateDimension(stringBounder);
                Dimension2D dimension2D2 = textBlock3.calculateDimension(stringBounder);
                return USymbolRect.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimension2D2, dimension2D));
            }
        };
    }

    public TextBlock asBig(final TextBlock textBlock, final TextBlock textBlock2, final double d, final double d2, final SymbolContext symbolContext) {
        return new AbstractTextBlock(){

            public void drawU(UGraphic uGraphic) {
                double d4;
                double d22;
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                uGraphic = symbolContext.apply(uGraphic);
                USymbolRect.this.drawRect(uGraphic, dimension2D.getWidth(), dimension2D.getHeight(), symbolContext.isShadowing(), symbolContext.getRoundCorner());
                Dimension2D dimension2D2 = textBlock2.calculateDimension(uGraphic.getStringBounder());
                if (USymbolRect.this.stereotypeAlignement == HorizontalAlignment.RIGHT) {
                    d22 = d - dimension2D2.getWidth() - USymbolRect.this.getMargin().getX1() / 2.0;
                    d4 = USymbolRect.this.getMargin().getY1() / 2.0;
                } else {
                    d22 = (d - dimension2D2.getWidth()) / 2.0;
                    d4 = 2.0;
                }
                textBlock2.drawU(uGraphic.apply(new UTranslate(d22, d4)));
                Dimension2D dimension2D3 = textBlock.calculateDimension(uGraphic.getStringBounder());
                double d3 = (d - dimension2D3.getWidth()) / 2.0;
                textBlock.drawU(uGraphic.apply(new UTranslate(d3, 2.0 + dimension2D2.getHeight())));
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(d, d2);
            }
        };
    }

    public boolean manageHorizontalLine() {
        return true;
    }
}

