/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.skin.bluemodern;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.ArrowConfiguration;
import znaishaded.net.sourceforge.plantuml.skin.ArrowPart;
import znaishaded.net.sourceforge.plantuml.skin.bluemodern.AbstractComponentBlueModernArrow;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentBlueModernSelfArrow
extends AbstractComponentBlueModernArrow {
    private final double arrowWidth = 45.0;

    public ComponentBlueModernSelfArrow(HtmlColor htmlColor, FontConfiguration fontConfiguration, Display display, ArrowConfiguration arrowConfiguration, ISkinSimple iSkinSimple) {
        super(htmlColor, fontConfiguration, display, arrowConfiguration, iSkinSimple);
    }

    protected void drawInternalU(UGraphic uGraphic, Area area) {
        if (this.getArrowConfiguration().isHidden()) {
            return;
        }
        StringBounder stringBounder = uGraphic.getStringBounder();
        int n = (int)this.getTextHeight(stringBounder);
        uGraphic = uGraphic.apply(new UChangeBackColor(this.getForegroundColor())).apply(new UChangeColor(this.getForegroundColor()));
        uGraphic = this.getArrowConfiguration().isDotted() ? ArrowConfiguration.stroke(uGraphic, 5.0, 2.0, 1.0) : uGraphic.apply(new UStroke(2.0));
        uGraphic.apply(new UTranslate(0.0, n)).draw(new ULine(42.0, 0.0));
        int n2 = (int)((double)n + this.getArrowOnlyHeight(stringBounder));
        uGraphic.apply(new UTranslate(42.0, n)).draw(new ULine(0.0, n2 - n));
        uGraphic.apply(new UTranslate(42.0, n2)).draw(new ULine(-40.0, 0.0));
        uGraphic = uGraphic.apply(new UStroke());
        int n3 = (int)this.getArrowOnlyHeight(stringBounder);
        if (this.getArrowConfiguration().isAsync()) {
            if (this.getArrowConfiguration().getPart() != ArrowPart.BOTTOM_PART) {
                uGraphic.apply(new UStroke(1.5)).apply(new UTranslate(this.getArrowDeltaX2(), n - this.getArrowDeltaY2() + n3)).draw(new ULine(-this.getArrowDeltaX2(), this.getArrowDeltaY2()));
            }
            if (this.getArrowConfiguration().getPart() != ArrowPart.TOP_PART) {
                uGraphic.apply(new UStroke(1.5)).apply(new UTranslate(this.getArrowDeltaX2(), n + this.getArrowDeltaY2() + n3)).draw(new ULine(-this.getArrowDeltaX2(), -this.getArrowDeltaY2()));
            }
        } else {
            UPolygon uPolygon = this.getPolygon(n, n3);
            uGraphic.draw(uPolygon);
        }
        this.getTextBlock().drawU(uGraphic.apply(new UTranslate(this.getMarginX1(), 0.0)));
    }

    private UPolygon getPolygon(int n, int n2) {
        UPolygon uPolygon = new UPolygon();
        if (this.getArrowConfiguration().getPart() == ArrowPart.TOP_PART) {
            uPolygon.addPoint(this.getArrowDeltaX(), n - this.getArrowDeltaY() + n2);
            uPolygon.addPoint(0.0, n + n2);
            uPolygon.addPoint(this.getArrowDeltaX(), n + n2);
        } else if (this.getArrowConfiguration().getPart() == ArrowPart.BOTTOM_PART) {
            uPolygon.addPoint(this.getArrowDeltaX(), n + n2);
            uPolygon.addPoint(0.0, n + n2);
            uPolygon.addPoint(this.getArrowDeltaX(), n + this.getArrowDeltaY() + n2);
        } else {
            uPolygon.addPoint(this.getArrowDeltaX(), n - this.getArrowDeltaY() + n2);
            uPolygon.addPoint(0.0, n + n2);
            uPolygon.addPoint(this.getArrowDeltaX(), n + this.getArrowDeltaY() + n2);
        }
        return uPolygon;
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + (double)this.getArrowDeltaY() + this.getArrowOnlyHeight(stringBounder) + 2.0 * this.getPaddingY();
    }

    private double getArrowOnlyHeight(StringBounder stringBounder) {
        return 13.0;
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return Math.max(this.getTextWidth(stringBounder), 45.0);
    }

    public Point2D getStartPoint(StringBounder stringBounder, Dimension2D dimension2D) {
        int n = (int)this.getTextHeight(stringBounder);
        return new Point2D.Double(this.getPaddingX(), (double)n + this.getPaddingY());
    }

    public Point2D getEndPoint(StringBounder stringBounder, Dimension2D dimension2D) {
        int n = (int)this.getTextHeight(stringBounder);
        int n2 = (int)((double)n + this.getArrowOnlyHeight(stringBounder));
        return new Point2D.Double(this.getPaddingX(), (double)n2 + this.getPaddingY());
    }
}

