/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.timingdiagram;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorUtils;
import znaishaded.net.sourceforge.plantuml.graphic.InnerStrategy;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.SymbolContext;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.timingdiagram.ChangeState;
import znaishaded.net.sourceforge.plantuml.timingdiagram.IntricatedPoint;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimeConstraint;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimeDrawing;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimeTick;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimingRuler;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Histogram
implements TimeDrawing {
    private final List<ChangeState> changes = new ArrayList<ChangeState>();
    private final List<TimeConstraint> constraints = new ArrayList<TimeConstraint>();
    private List<String> allStates = new ArrayList<String>();
    private final double stepHeight = 20.0;
    private final ISkinParam skinParam;
    private final TimingRuler ruler;
    private String initialState;

    public Histogram(TimingRuler timingRuler, ISkinParam iSkinParam) {
        this.ruler = timingRuler;
        this.skinParam = iSkinParam;
    }

    @Override
    public IntricatedPoint getTimeProjection(StringBounder stringBounder, TimeTick timeTick) {
        double d = this.ruler.getPosInPixel(timeTick);
        List<String> list = this.getStatesAt(timeTick);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            double d2 = this.getStateYFor(list.get(0));
            return new IntricatedPoint(new Point2D.Double(d, d2), new Point2D.Double(d, d2));
        }
        assert (list.size() == 2);
        double d3 = this.getStateYFor(list.get(0));
        double d4 = this.getStateYFor(list.get(1));
        assert (d3 != d4);
        return new IntricatedPoint(new Point2D.Double(d, d3), new Point2D.Double(d, d4));
    }

    private double getStateYFor(String string) {
        return (double)(this.allStates.size() - 1 - this.allStates.indexOf(string)) * 20.0;
    }

    private List<String> getStatesAt(TimeTick timeTick) {
        if (this.changes.size() == 0) {
            return Collections.emptyList();
        }
        for (int i = 0; i < this.changes.size(); ++i) {
            if (this.changes.get(i).getWhen().compareTo(timeTick) == 0) {
                if (i == 0 && this.initialState == null) {
                    return Arrays.asList(this.changes.get(i).getState());
                }
                if (i == 0 && this.initialState != null) {
                    return Arrays.asList(this.initialState, this.changes.get(i).getState());
                }
                return Arrays.asList(this.changes.get(i - 1).getState(), this.changes.get(i).getState());
            }
            if (this.changes.get(i).getWhen().compareTo(timeTick) <= 0) continue;
            return Collections.singletonList(this.changes.get(i - 1).getState());
        }
        return Collections.singletonList(this.changes.get(this.changes.size() - 1).getState());
    }

    @Override
    public void addChange(ChangeState changeState) {
        String string = changeState.getState();
        if (!this.allStates.contains(string)) {
            this.allStates.add(string);
        }
        this.changes.add(changeState);
    }

    private Point2D getPoint(int n) {
        ChangeState changeState = this.changes.get(n);
        double d = this.ruler.getPosInPixel(changeState.getWhen());
        return new Point2D.Double(d, this.yOfState(changeState.getState()));
    }

    private double yOfState(String string) {
        return -20.0 * (double)this.allStates.indexOf(string);
    }

    private SymbolContext getContext() {
        return new SymbolContext(HtmlColorUtils.COL_D7E0F2, HtmlColorUtils.COL_038048).withStroke(new UStroke(1.5));
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        Object object;
        Object object2;
        int n;
        uGraphic = this.getContext().apply(uGraphic);
        UTranslate uTranslate = new UTranslate(0.0, this.getFullDeltaY());
        if (this.changes.size() == 0) {
            return;
        }
        if (this.initialState != null) {
            Point2D point2D = this.getPoint(0);
            this.drawHLine(uGraphic, this.getInitialPoint(), this.getInitialWidth() + point2D.getX());
        }
        for (int i = 0; i < this.changes.size() - 1; ++i) {
            Point2D point2D = this.getPoint(i);
            Point2D point2D2 = this.getPoint(i + 1);
            double d = point2D2.getX() - point2D.getX();
            this.drawHLine(uGraphic, point2D, d);
        }
        Point2D point2D = this.getPoint(this.changes.size() - 1);
        double d = this.ruler.getWidth() - point2D.getX();
        this.drawHLine(uGraphic, point2D, d);
        if (this.initialState != null) {
            Point2D.Double double_ = this.getInitialPoint();
            Point2D object32 = this.getPoint(0);
            uGraphic.apply(new UTranslate(object32).compose(uTranslate)).draw(new ULine(0.0, ((Point2D)double_).getY() - object32.getY()));
        }
        for (n = 1; n < this.changes.size(); ++n) {
            Point2D point2D2 = this.getPoint(n - 1);
            object2 = this.getPoint(n);
            uGraphic.apply(new UTranslate((Point2D)object2).compose(uTranslate)).draw(new ULine(0.0, point2D2.getY() - ((Point2D)object2).getY()));
        }
        for (n = 0; n < this.changes.size(); ++n) {
            Point2D point2D3 = this.getPoint(n);
            object2 = this.changes.get(n).getComment();
            if (object2 == null) continue;
            object = this.getTextBlock((String)object2);
            Dimension2D dimension2D = object.calculateDimension(uGraphic.getStringBounder());
            object.drawU(uGraphic.apply(new UTranslate(point2D3).compose(uTranslate).compose(new UTranslate(2.0, -dimension2D.getHeight()))));
        }
        for (TimeConstraint timeConstraint : this.constraints) {
            object2 = Histogram.last(this.getStatesAt(timeConstraint.getTick1()));
            object = this.getStatesAt(timeConstraint.getTick2()).get(0);
            double d2 = this.getStateYFor((String)object2);
            double d3 = this.getStateYFor((String)object);
            timeConstraint.drawU(uGraphic.apply(new UTranslate(0.0, d2 - 10.0)), this.ruler, this.skinParam);
        }
    }

    private static String last(List<String> list) {
        return list.get(list.size() - 1);
    }

    private Point2D.Double getInitialPoint() {
        return new Point2D.Double(-this.getInitialWidth(), this.yOfState(this.initialState));
    }

    private void drawHLine(UGraphic uGraphic, Point2D point2D, double d) {
        UTranslate uTranslate = new UTranslate(0.0, this.getFullDeltaY());
        UTranslate uTranslate2 = new UTranslate(point2D).compose(uTranslate);
        uGraphic = uGraphic.apply(uTranslate2);
        uGraphic.draw(new ULine(d, 0.0));
    }

    private double getFullDeltaY() {
        return 20.0 * (double)(this.allStates.size() - 1);
    }

    private FontConfiguration getFontConfiguration() {
        return new FontConfiguration(this.skinParam, FontParam.ACTIVITY, null);
    }

    private TextBlock getTextBlock(String string) {
        Display display = Display.getWithNewlines(string);
        return display.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    @Override
    public double getHeight() {
        return 20.0 * (double)this.allStates.size() + 10.0;
    }

    @Override
    public TextBlock getWidthHeader(StringBounder stringBounder) {
        return new TextBlock(){

            public void drawU(UGraphic uGraphic) {
                for (String string : Histogram.this.allStates) {
                    TextBlock textBlock = Histogram.this.getTextBlock(string);
                    Dimension2D dimension2D = textBlock.calculateDimension(uGraphic.getStringBounder());
                    textBlock.drawU(uGraphic.apply(new UTranslate(0.0, Histogram.this.getFullDeltaY() + Histogram.this.yOfState(string) - dimension2D.getHeight())));
                }
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                double d = 0.0;
                for (String string : Histogram.this.allStates) {
                    TextBlock textBlock = Histogram.this.getTextBlock(string);
                    Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
                    d = Math.max(d, dimension2D.getWidth());
                }
                if (Histogram.this.initialState != null) {
                    d += Histogram.this.getInitialWidth();
                }
                return new Dimension2DDouble(d, Histogram.this.getFullDeltaY());
            }

            public Rectangle2D getInnerPosition(String string, StringBounder stringBounder, InnerStrategy innerStrategy) {
                return null;
            }
        };
    }

    @Override
    public void setInitialState(String string, Colors colors) {
        this.initialState = string;
        if (string != null) {
            this.allStates.add(string);
        }
    }

    private double getInitialWidth() {
        return 40.0;
    }

    @Override
    public void addConstraint(TimeConstraint timeConstraint) {
        this.constraints.add(timeConstraint);
    }
}

