/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.eps;

import java.awt.Color;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.eps.EpsGraphics;
import znaishaded.net.sourceforge.plantuml.eps.EpsGraphicsMacroAndText;
import znaishaded.net.sourceforge.plantuml.eps.EpsStrategy;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.FontStyle;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.ugraphic.ClipContainer;
import znaishaded.net.sourceforge.plantuml.ugraphic.ColorMapper;
import znaishaded.net.sourceforge.plantuml.ugraphic.MinMax;
import znaishaded.net.sourceforge.plantuml.ugraphic.UClip;
import znaishaded.net.sourceforge.plantuml.ugraphic.UDriver;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UParam;
import znaishaded.net.sourceforge.plantuml.ugraphic.UShape;
import znaishaded.net.sourceforge.plantuml.ugraphic.UText;
import znaishaded.net.sourceforge.plantuml.ugraphic.eps.PathIteratorLimited;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverTextEps
implements UDriver<EpsGraphics> {
    private final StringBounder stringBounder = FileFormat.PNG.getDefaultStringBounder();
    private final ClipContainer clipContainer;
    private final FontRenderContext fontRenderContext;
    private final EpsStrategy strategy;

    public DriverTextEps(ClipContainer clipContainer, EpsStrategy epsStrategy) {
        this.clipContainer = clipContainer;
        this.fontRenderContext = TextBlockUtils.getFontRenderContext();
        this.strategy = epsStrategy;
    }

    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, EpsGraphics epsGraphics) {
        Object object;
        UClip uClip = this.clipContainer.getClip();
        if (uClip != null && !uClip.isInside(d, d2)) {
            return;
        }
        UText uText = (UText)uShape;
        if (this.strategy == EpsStrategy.WITH_MACRO_AND_TEXT) {
            this.drawAsText(uText, d, d2, uParam, epsGraphics, colorMapper);
            return;
        }
        FontConfiguration fontConfiguration = uText.getFontConfiguration();
        UFont uFont = fontConfiguration.getFont();
        TextLayout textLayout = new TextLayout(uText.getText(), uFont.getFont(), this.fontRenderContext);
        MinMax minMax = null;
        if (fontConfiguration.containsStyle(FontStyle.BACKCOLOR) && (object = colorMapper.getMappedColor(fontConfiguration.getExtendedColor())) != null) {
            epsGraphics.setStrokeColor((Color)object);
            epsGraphics.setFillColor((Color)object);
            epsGraphics.setStrokeWidth("1", 0.0, 0.0);
            if (minMax == null) {
                minMax = DriverTextEps.getMinMax(d, d2, this.getOutline(textLayout).getPathIterator(null));
            }
            epsGraphics.epsRectangle(minMax.getMinX() - 1.0, minMax.getMinY() - 1.0, minMax.getWidth() + 2.0, minMax.getHeight() + 2.0, 0.0, 0.0);
        }
        epsGraphics.setStrokeColor(colorMapper.getMappedColor(fontConfiguration.getColor()));
        DriverTextEps.drawPathIterator(epsGraphics, d, d2, this.getOutline(textLayout));
        if (fontConfiguration.containsStyle(FontStyle.UNDERLINE)) {
            object = fontConfiguration.getExtendedColor();
            if (object != null) {
                epsGraphics.setStrokeColor(colorMapper.getMappedColor((HtmlColor)object));
            }
            if (minMax == null) {
                minMax = DriverTextEps.getMinMax(d, d2, this.getOutline(textLayout).getPathIterator(null));
            }
            epsGraphics.setStrokeWidth("1.1", 0.0, 0.0);
            epsGraphics.epsLine(d, d2 + 1.5, d + minMax.getWidth(), d2 + 1.5);
            epsGraphics.setStrokeWidth("1", 0.0, 0.0);
        }
        if (fontConfiguration.containsStyle(FontStyle.WAVE)) {
            if (minMax == null) {
                minMax = DriverTextEps.getMinMax(d, d2, this.getOutline(textLayout).getPathIterator(null));
            }
            int n = (int)(d2 + 2.5) - 1;
            HtmlColor htmlColor = fontConfiguration.getExtendedColor();
            if (htmlColor != null) {
                epsGraphics.setStrokeColor(colorMapper.getMappedColor(htmlColor));
            }
            epsGraphics.setStrokeWidth("1.1", 0.0, 0.0);
            int n2 = (int)d;
            while ((double)n2 < d + minMax.getWidth() - 5.0) {
                epsGraphics.epsLine(n2, n - 0, n2 + 3, n + 1);
                epsGraphics.epsLine(n2 + 3, n + 1, n2 + 6, n - 0);
                n2 += 6;
            }
            epsGraphics.setStrokeWidth("1", 0.0, 0.0);
        }
        if (fontConfiguration.containsStyle(FontStyle.STRIKE)) {
            HtmlColor htmlColor = fontConfiguration.getExtendedColor();
            if (htmlColor != null) {
                epsGraphics.setStrokeColor(colorMapper.getMappedColor(htmlColor));
            }
            if (minMax == null) {
                minMax = DriverTextEps.getMinMax(d, d2, this.getOutline(textLayout).getPathIterator(null));
            }
            double d3 = (minMax.getMinY() + minMax.getMaxY() * 2.0) / 3.0;
            epsGraphics.setStrokeWidth("1.3", 0.0, 0.0);
            epsGraphics.epsLine(d, d3, d + minMax.getWidth(), d3);
            epsGraphics.setStrokeWidth("1", 0.0, 0.0);
        }
    }

    private Shape getOutline(TextLayout textLayout) {
        return textLayout.getOutline(null);
    }

    private void drawAsText(UText uText, double d, double d2, UParam uParam, EpsGraphics epsGraphics, ColorMapper colorMapper) {
        FontConfiguration fontConfiguration = uText.getFontConfiguration();
        double d3 = d2 - 1.0;
        epsGraphics.setStrokeColor(colorMapper.getMappedColor(fontConfiguration.getColor()));
        ((EpsGraphicsMacroAndText)epsGraphics).drawText(uText.getText(), fontConfiguration, d, d3);
    }

    static void drawPathIterator(EpsGraphics epsGraphics, double d, double d2, Shape shape) {
        List<Integer> list = DriverTextEps.analyze(shape);
        if (list.size() == 0) {
            PathIterator pathIterator = shape.getPathIterator(null);
            DriverTextEps.drawSingle(epsGraphics, d, d2, pathIterator);
            return;
        }
        PathIteratorLimited pathIteratorLimited = new PathIteratorLimited(shape, 0, list.get(0));
        DriverTextEps.drawSingle(epsGraphics, d, d2, pathIteratorLimited);
        for (int i = 0; i < list.size() - 1; ++i) {
            PathIteratorLimited pathIteratorLimited2 = new PathIteratorLimited(shape, list.get(i) + 1, list.get(i + 1));
            DriverTextEps.drawSingle(epsGraphics, d, d2, pathIteratorLimited2);
        }
        PathIteratorLimited pathIteratorLimited3 = new PathIteratorLimited(shape, list.get(list.size() - 1) + 1, Integer.MAX_VALUE);
        DriverTextEps.drawSingle(epsGraphics, d, d2, pathIteratorLimited3);
    }

    private static void drawSingle(EpsGraphics epsGraphics, double d, double d2, PathIterator pathIterator) {
        epsGraphics.newpath();
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            if (n == 0) {
                epsGraphics.moveto(dArray[0] + d, dArray[1] + d2);
            } else if (n == 1) {
                epsGraphics.lineto(dArray[0] + d, dArray[1] + d2);
            } else if (n == 4) {
                epsGraphics.closepath();
            } else if (n == 3) {
                epsGraphics.curveto(dArray[0] + d, dArray[1] + d2, dArray[2] + d, dArray[3] + d2, dArray[4] + d, dArray[5] + d2);
            } else if (n == 2) {
                epsGraphics.quadto(dArray[0] + d, dArray[1] + d2, dArray[2] + d, dArray[3] + d2);
            } else {
                throw new UnsupportedOperationException("code=" + n);
            }
            pathIterator.next();
        }
        epsGraphics.fill(pathIterator.getWindingRule());
    }

    private static List<Integer> analyze(Shape shape) {
        int n = PathIteratorLimited.count(shape);
        List<Integer> list = DriverTextEps.getClosings(shape.getPathIterator(null));
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Integer n2 : list) {
            if (n2 + 2 >= n) break;
            PathIteratorLimited pathIteratorLimited = new PathIteratorLimited(shape, 0, n2);
            PathIteratorLimited pathIteratorLimited2 = new PathIteratorLimited(shape, n2 + 1, Integer.MAX_VALUE);
            double d = DriverTextEps.getMinMax(0.0, 0.0, pathIteratorLimited).getMaxX();
            double d2 = DriverTextEps.getMinMax(0.0, 0.0, pathIteratorLimited2).getMinX();
            if (!(d2 > d)) continue;
            arrayList.add(n2);
        }
        return arrayList;
    }

    private static List<Integer> getClosings(PathIterator pathIterator) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(dArray);
            if (n2 == 4) {
                arrayList.add(n);
            }
            ++n;
            pathIterator.next();
        }
        return arrayList;
    }

    private static MinMax getMinMax(double d, double d2, PathIterator pathIterator) {
        MinMax minMax = MinMax.getEmpty(false);
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            if (n == 0) {
                minMax = minMax.addPoint(dArray[0] + d, dArray[1] + d2);
            } else if (n == 1) {
                minMax = minMax.addPoint(dArray[0] + d, dArray[1] + d2);
            } else if (n != 4) {
                if (n == 3) {
                    minMax = minMax.addPoint(dArray[0] + d, dArray[1] + d2);
                    minMax = minMax.addPoint(dArray[2] + d, dArray[3] + d2);
                    minMax = minMax.addPoint(dArray[4] + d, dArray[5] + d2);
                } else if (n == 2) {
                    minMax = minMax.addPoint(dArray[0] + d, dArray[1] + d2);
                    minMax = minMax.addPoint(dArray[2] + d, dArray[3] + d2);
                } else {
                    throw new UnsupportedOperationException("code=" + n);
                }
            }
            pathIterator.next();
        }
        return minMax;
    }
}

